/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.magnet;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.wrapper.URIWrapper;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.Magnet;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.StringUtils;

public final class MagnetBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MagnetBuilder.class);
    public static final String QUERY_DN = "dn";
    public static final String QUERY_XL = "xl";
    public static final String QUERY_XT = "xt";
    public static final String QUERY_AS = "as";
    public static final String QUERY_XS = "xs";
    public static final String QUERY_TR = "tr";
    private final String url;
    private Magnet magnet;

    private MagnetBuilder(String url) throws DownloadException {
        if (!Protocol.Type.MAGNET.verify(url)) {
            throw new DownloadException("\u78c1\u529b\u94fe\u63a5\u683c\u5f0f\u9519\u8bef\uff1a" + url);
        }
        this.url = url;
    }

    public static final MagnetBuilder newInstance(String url) throws DownloadException {
        return new MagnetBuilder(url);
    }

    public Magnet build() throws DownloadException {
        String[] querys;
        this.magnet = new Magnet();
        if (Protocol.Type.verifyMagnetHash32(this.url)) {
            this.magnet.setType(Magnet.Type.BTIH);
            this.magnet.setHash(InfoHash.newInstance(this.url).getInfoHashHex());
            return this.magnet;
        }
        if (Protocol.Type.verifyMagnetHash40(this.url)) {
            this.magnet.setType(Magnet.Type.BTIH);
            this.magnet.setHash(this.url);
            return this.magnet;
        }
        for (String query : querys = URIWrapper.newInstance(this.url).decode().getQuerys()) {
            int index = query.indexOf(SymbolConfig.Symbol.EQUALS.toChar());
            if (index >= 0 && query.length() > index) {
                String key = query.substring(0, index);
                String value = query.substring(index + 1);
                switch (key) {
                    case "dn": {
                        this.dn(value);
                        break;
                    }
                    case "xl": {
                        this.xl(value);
                        break;
                    }
                    case "xt": {
                        this.xt(value);
                        break;
                    }
                    case "as": {
                        this.as(value);
                        break;
                    }
                    case "xs": {
                        this.xs(value);
                        break;
                    }
                    case "tr": {
                        this.tr(value);
                        break;
                    }
                    default: {
                        LOGGER.debug("\u78c1\u529b\u94fe\u63a5\u4e0d\u652f\u6301\u7684\u53c2\u6570\uff1a{}-{}-{}", key, value, this.url);
                        break;
                    }
                }
                continue;
            }
            LOGGER.debug("\u78c1\u529b\u94fe\u63a5\u9519\u8bef\u53c2\u6570\uff1a{}-{}", query, this.url);
        }
        if (this.magnet.supportDownload()) {
            return this.magnet;
        }
        throw new DownloadException("\u78c1\u529b\u94fe\u63a5\u65b0\u5efa\u5931\u8d25\uff1a" + this.url);
    }

    private void dn(String value) {
        this.magnet.setDn(value);
    }

    private void xl(String value) {
        if (StringUtils.isNumeric(value)) {
            this.magnet.setXl(Long.valueOf(value));
        }
    }

    private void xt(String value) throws DownloadException {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        String prefix = Magnet.Type.BTIH.prefix();
        if (!value.startsWith(prefix)) {
            LOGGER.debug("\u78c1\u529b\u94fe\u63a5\u4e0d\u652f\u6301\u7684XT\uff1a{}", value);
            return;
        }
        String hash = value.substring(prefix.length());
        if (Protocol.Type.verifyMagnetHash32(hash)) {
            hash = InfoHash.newInstance(hash).getInfoHashHex();
        }
        this.magnet.setXt(value);
        this.magnet.setHash(hash);
        this.magnet.setType(Magnet.Type.BTIH);
    }

    private void as(String value) {
        this.magnet.setAs(value);
    }

    private void xs(String value) {
        this.magnet.setXs(value);
    }

    private void tr(String value) {
        this.magnet.addTr(value);
    }
}

