/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.magnet;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.downloader.magnet.MagnetDownloader;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.torrent.Magnet;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.protocol.magnet.MagnetBuilder;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.StringUtils;

public final class MagnetProtocol
extends Protocol {
    private static final MagnetProtocol INSTANCE = new MagnetProtocol();
    private Magnet magnet;

    public static final MagnetProtocol getInstance() {
        return INSTANCE;
    }

    private MagnetProtocol() {
        super(Protocol.Type.MAGNET, "\u78c1\u529b\u94fe\u63a5");
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public IDownloader buildDownloader(ITaskSession taskSession) {
        return MagnetDownloader.newInstance(taskSession);
    }

    @Override
    protected void prep() throws DownloadException {
        Magnet magnetCheck = MagnetBuilder.newInstance(this.url).build();
        this.checkExist(magnetCheck);
        this.magnet = magnetCheck;
    }

    @Override
    protected String buildFileName() {
        String dn = this.magnet.getDn();
        if (StringUtils.isNotEmpty(dn)) {
            return dn;
        }
        return this.magnet.getHash();
    }

    @Override
    protected void buildName(String fileName) {
        this.taskEntity.setName(fileName);
    }

    @Override
    protected void buildFileType(String fileName) {
        this.taskEntity.setFileType(ITaskSession.FileType.TORRENT);
    }

    @Override
    protected void buildSize() throws DownloadException {
        this.taskEntity.setSize(0L);
    }

    @Override
    protected void done() {
        this.buildFolder();
    }

    @Override
    protected void release(boolean success) {
        if (!success && this.magnet != null) {
            TorrentContext.getInstance().remove(this.magnet.getHash());
        }
        this.magnet = null;
        super.release(success);
    }

    private void checkExist(Magnet magnet) throws DownloadException {
        if (TorrentContext.getInstance().exist(magnet.getHash())) {
            throw new DownloadException("\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728");
        }
    }

    private void buildFolder() {
        FileUtils.buildFolder(this.taskEntity.getFile());
    }
}

