/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.magnet;

import com.acgist.snail.config.SystemConfig;
import com.acgist.snail.format.BEncodeDecoder;
import com.acgist.snail.format.BEncodeEncoder;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.PacketSizeException;
import com.acgist.snail.net.torrent.InfoHash;
import com.acgist.snail.net.torrent.dht.NodeContext;
import com.acgist.snail.net.torrent.dht.NodeSession;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.DateUtils;
import com.acgist.snail.utils.FileUtils;
import com.acgist.snail.utils.NetUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class TorrentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentBuilder.class);
    private final InfoHash infoHash;
    private final List<String> trackers;

    private TorrentBuilder(InfoHash infoHash, List<String> trackers) {
        this.infoHash = infoHash;
        this.trackers = trackers;
    }

    public static final TorrentBuilder newInstance(InfoHash infoHash, List<String> trackers) {
        return new TorrentBuilder(infoHash, trackers);
    }

    public String buildFile(String path) throws PacketSizeException {
        String fileName = this.buildFileName();
        String filePath = FileUtils.file(path, fileName);
        Map<String, Object> fileInfo = this.buildFileInfo();
        this.buildFile(filePath, fileInfo);
        return filePath;
    }

    private Map<String, Object> buildFileInfo() throws PacketSizeException {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("comment", SystemConfig.getSource());
        data.put("comment.utf-8", SystemConfig.getSource());
        data.put("encoding", "UTF-8");
        data.put("created by", SystemConfig.getNameEnAndVersion());
        data.put("creation date", DateUtils.unixTimestamp());
        this.buildAnnounce(data);
        this.buildInfo(data);
        this.buildNodes(data);
        return data;
    }

    private void buildAnnounce(Map<String, Object> data) {
        if (CollectionUtils.isEmpty(this.trackers)) {
            return;
        }
        data.put("announce", this.trackers.get(0));
        boolean skipSize = true;
        if (this.trackers.size() > 1) {
            data.put("announce-list", this.trackers.stream().skip(1L).map(List::of).collect(Collectors.toList()));
        }
    }

    private void buildInfo(Map<String, Object> data) throws PacketSizeException {
        BEncodeDecoder decoder = BEncodeDecoder.newInstance(this.infoHash.getInfo());
        data.put("info", decoder.nextMap());
    }

    private void buildNodes(Map<String, Object> data) {
        List nodes;
        List<NodeSession> sessions = NodeContext.getInstance().findNode(this.infoHash.getInfoHash());
        if (CollectionUtils.isNotEmpty(sessions) && CollectionUtils.isNotEmpty(nodes = sessions.stream().filter(session -> NetUtils.ip(session.getHost())).map(session -> List.of(session.getHost(), Integer.valueOf(session.getPort()))).collect(Collectors.toList()))) {
            data.put("nodes", nodes);
        }
    }

    private String buildFileName() {
        return this.infoHash.getInfoHashHex() + Protocol.Type.TORRENT.defaultSuffix();
    }

    private void buildFile(String filePath, Map<String, Object> fileInfo) {
        File file = new File(filePath);
        if (file.exists()) {
            LOGGER.debug("\u79cd\u5b50\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff1a{}", filePath);
            return;
        }
        LOGGER.debug("\u4fdd\u5b58\u79cd\u5b50\u6587\u4ef6\uff1a{}", filePath);
        byte[] bytes = BEncodeEncoder.encodeMap(fileInfo);
        FileUtils.write(filePath, bytes);
    }
}

