/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.thunder;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.protocol.ProtocolContext;
import com.acgist.snail.utils.StringUtils;
import java.util.Base64;
import java.util.Optional;

public final class ThunderProtocol
extends Protocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThunderProtocol.class);
    private static final ThunderProtocol INSTANCE = new ThunderProtocol();
    private static final String THUNDER_PREFIX = "AA";
    private static final String THUNDER_SUFFIX = "ZZ";

    public static final ThunderProtocol getInstance() {
        return INSTANCE;
    }

    private ThunderProtocol() {
        super(Protocol.Type.THUNDER, "\u8fc5\u96f7\u94fe\u63a5");
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public IDownloader buildDownloader(ITaskSession taskSession) {
        return null;
    }

    @Override
    public synchronized ITaskSession buildTaskSession(String url) throws DownloadException {
        String sourceUrl = this.sourceUrl(url);
        LOGGER.debug("\u8fc5\u96f7\u539f\u59cb\u94fe\u63a5\uff1a{}", sourceUrl);
        Optional<Protocol> sourceProtocol = ProtocolContext.getInstance().protocol(sourceUrl);
        if (sourceProtocol.isEmpty()) {
            throw new DownloadException("\u4e0d\u652f\u6301\u7684\u4e0b\u8f7d\u94fe\u63a5\uff1a" + url);
        }
        return sourceProtocol.get().buildTaskSession(sourceUrl);
    }

    public String sourceUrl(String url) {
        String prefix = Protocol.Type.THUNDER.prefix(url);
        String sourceUrl = url.substring(prefix.length());
        sourceUrl = new String(Base64.getMimeDecoder().decode(sourceUrl));
        sourceUrl = sourceUrl.substring(THUNDER_PREFIX.length(), sourceUrl.length() - THUNDER_SUFFIX.length());
        return sourceUrl;
    }

    public String thunderUrl(String url) {
        Object thunderUrl = THUNDER_PREFIX + url + THUNDER_SUFFIX;
        thunderUrl = Base64.getMimeEncoder().encodeToString(((String)thunderUrl).getBytes());
        thunderUrl = Protocol.Type.THUNDER.defaultPrefix() + (String)thunderUrl;
        return StringUtils.replaceAllBlank((String)thunderUrl);
    }
}

