/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.protocol.torrent;

import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.context.session.TaskSession;
import com.acgist.snail.downloader.IDownloader;
import com.acgist.snail.downloader.torrent.TorrentDownloader;
import com.acgist.snail.gui.GuiContext;
import com.acgist.snail.net.DownloadException;
import com.acgist.snail.net.torrent.Torrent;
import com.acgist.snail.net.torrent.TorrentContext;
import com.acgist.snail.net.torrent.TorrentSession;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.FileUtils;

public final class TorrentProtocol
extends Protocol {
    private static final TorrentProtocol INSTANCE = new TorrentProtocol();
    private String torrentFile;
    private TorrentSession torrentSession;
    private TorrentHandle handle = TorrentHandle.COPY;

    public static final TorrentProtocol getInstance() {
        return INSTANCE;
    }

    private TorrentProtocol() {
        super(Protocol.Type.TORRENT, "BitTorrent");
    }

    public void torrentHandle(TorrentHandle handle) {
        this.handle = handle;
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public IDownloader buildDownloader(ITaskSession taskSession) {
        return TorrentDownloader.newInstance(taskSession);
    }

    @Override
    protected void prep() throws DownloadException {
        this.checkExist();
        this.torrent();
    }

    @Override
    protected String buildFileName() {
        return this.torrentSession.name();
    }

    @Override
    protected void buildName(String fileName) {
        this.taskEntity.setName(fileName);
    }

    @Override
    protected void buildFileType(String fileName) {
        this.taskEntity.setFileType(ITaskSession.FileType.TORRENT);
    }

    @Override
    protected void buildSize() throws DownloadException {
    }

    @Override
    protected void done() throws DownloadException {
        this.buildFolder();
        this.torrentHandle();
        this.selectFiles();
    }

    @Override
    protected void release(boolean success) {
        if (!success && this.torrentSession != null) {
            FileUtils.delete(this.taskEntity.getFile());
            TorrentContext.getInstance().remove(this.torrentSession.infoHashHex());
        }
        this.torrentFile = null;
        this.torrentSession = null;
        super.release(success);
    }

    private void checkExist() throws DownloadException {
        Torrent torrent = TorrentContext.loadTorrent(this.url);
        if (TorrentContext.getInstance().exist(torrent.infoHash().getInfoHashHex())) {
            throw new DownloadException("\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728");
        }
    }

    private void torrent() throws DownloadException {
        this.torrentFile = this.url;
        this.torrentSession = TorrentContext.getInstance().newTorrentSession(this.torrentFile);
        this.url = Protocol.Type.buildMagnet(this.torrentSession.infoHash().getInfoHashHex());
    }

    private void buildFolder() {
        FileUtils.buildFolder(this.taskEntity.getFile());
    }

    private void torrentHandle() {
        String fileName = FileUtils.fileName(this.torrentFile);
        String newFilePath = FileUtils.file(this.taskEntity.getFile(), fileName);
        if (this.handle == TorrentHandle.MOVE) {
            FileUtils.move(this.torrentFile, newFilePath);
        } else {
            FileUtils.copy(this.torrentFile, newFilePath);
        }
        this.taskEntity.setTorrent(newFilePath);
    }

    private void selectFiles() throws DownloadException {
        ITaskSession taskSession;
        try {
            taskSession = TaskSession.newInstance(this.taskEntity);
            GuiContext.getInstance().multifile(taskSession);
        }
        catch (DownloadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DownloadException("\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6\u9519\u8bef", e);
        }
        if (taskSession.multifileSelected().isEmpty()) {
            throw new DownloadException("\u6ca1\u6709\u9009\u62e9\u4e0b\u8f7d\u6587\u4ef6");
        }
    }

    public static enum TorrentHandle {
        COPY,
        MOVE;

    }
}

