/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.utils.NumberUtils;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static final byte[] xor(byte[] sources, byte[] targets) {
        Objects.requireNonNull(sources, "\u5f02\u6216\u8fd0\u7b97\u539f\u59cb\u53c2\u6570\u9519\u8bef");
        Objects.requireNonNull(targets, "\u5f02\u6216\u8fd0\u7b97\u76ee\u6807\u53c2\u6570\u9519\u8bef");
        int length = sources.length;
        if (length != targets.length) {
            throw new IllegalArgumentException("\u5f02\u6216\u8fd0\u7b97\u53c2\u6570\u9519\u8bef\uff08\u957f\u5ea6\uff09");
        }
        byte[] value = new byte[length];
        for (int index = 0; index < length; ++index) {
            value[index] = (byte)(sources[index] ^ targets[index]);
        }
        return value;
    }

    public static final boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static final boolean isNotEmpty(Object[] objects) {
        return !ArrayUtils.isEmpty(objects);
    }

    public static final boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static final boolean isNotEmpty(byte[] bytes) {
        return !ArrayUtils.isEmpty(bytes);
    }

    public static final byte[] random(int length) {
        byte[] bytes = new byte[length];
        SecureRandom random = NumberUtils.random();
        ((Random)random).nextBytes(bytes);
        return bytes;
    }

    public static final int indexOf(int[] values, int value) {
        return ArrayUtils.indexOf(values, 0, values.length, value);
    }

    public static final int indexOf(int[] values, int fromIndex, int toIndex, int value) {
        toIndex = toIndex > values.length ? values.length : toIndex;
        for (int index = fromIndex; index < toIndex; ++index) {
            if (values[index] != value) continue;
            return index;
        }
        return -1;
    }

    public static final int indexOf(char[] values, char value) {
        return ArrayUtils.indexOf(values, 0, values.length, value);
    }

    public static final int indexOf(char[] values, int fromIndex, int toIndex, char value) {
        toIndex = toIndex > values.length ? values.length : toIndex;
        for (int index = fromIndex; index < toIndex; ++index) {
            if (values[index] != value) continue;
            return index;
        }
        return -1;
    }

    public static final void reverse(byte[] bytes) {
        int index = 0;
        for (int jndex = bytes.length - 1; jndex > index; --jndex, ++index) {
            byte value = bytes[jndex];
            bytes[jndex] = bytes[index];
            bytes[index] = value;
        }
    }
}

