/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

public final class Base32Utils {
    private static final char[] BASE_32_ENCODE;
    private static final byte[] BASE_32_DECODE;
    private static final int SIZE_BYTE = 8;
    private static final int SIZE_BASE_32 = 5;
    private static final int SIZE_LEFT = 3;

    private Base32Utils() {
    }

    public static final String encode(String content) {
        if (content == null) {
            return null;
        }
        return Base32Utils.encode(content.getBytes());
    }

    public static final String encode(byte[] content) {
        if (content == null) {
            return null;
        }
        int index = 0;
        int contentIndex = 0;
        int contentLength = content.length;
        char[] chars = new char[contentLength * 8 / 5 + (contentLength % 5 != 0 ? 1 : 0)];
        int charsLength = chars.length;
        for (int charsIndex = 0; charsIndex < charsLength; ++charsIndex) {
            if (index > 3) {
                int value = content[contentIndex] & 0xFF & 255 >> index;
                index = (index + 5) % 8;
                value <<= index;
                if (contentIndex < contentLength - 1) {
                    value |= (content[contentIndex + 1] & 0xFF) >> 8 - index;
                }
                chars[charsIndex] = BASE_32_ENCODE[value];
                ++contentIndex;
                continue;
            }
            chars[charsIndex] = BASE_32_ENCODE[content[contentIndex] >> 8 - (index + 5) & 0x1F];
            if ((index = (index + 5) % 8) != 0) continue;
            ++contentIndex;
        }
        return new String(chars);
    }

    public static final String decodeToString(String content) {
        if (content == null) {
            return null;
        }
        return new String(Base32Utils.decode(content));
    }

    public static final byte[] decode(String content) {
        if (content == null) {
            return null;
        }
        int index = 0;
        int bytesIndex = 0;
        char[] chars = content.toCharArray();
        int charsLength = chars.length;
        byte[] bytes = new byte[charsLength * 5 / 8];
        int bytesLength = bytes.length;
        for (int charsIndex = 0; charsIndex < charsLength; ++charsIndex) {
            byte value = BASE_32_DECODE[chars[charsIndex]];
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = bytesIndex++;
                    bytes[n] = (byte)(bytes[n] | value);
                    continue;
                }
                int n = bytesIndex;
                bytes[n] = (byte)(bytes[n] | value << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = bytesIndex++;
            bytes[n] = (byte)(bytes[n] | value >> index);
            if (bytesIndex >= bytesLength) continue;
            int n2 = bytesIndex;
            bytes[n2] = (byte)(bytes[n2] | value << 8 - index);
        }
        return bytes;
    }

    static {
        int index;
        BASE_32_ENCODE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'};
        BASE_32_DECODE = new byte[128];
        for (index = 0; index < BASE_32_DECODE.length; ++index) {
            Base32Utils.BASE_32_DECODE[index] = -1;
        }
        for (index = 0; index < BASE_32_ENCODE.length; ++index) {
            Base32Utils.BASE_32_DECODE[Base32Utils.BASE_32_ENCODE[index]] = (byte)index;
            Base32Utils.BASE_32_DECODE[Character.toLowerCase((char)Base32Utils.BASE_32_ENCODE[index])] = (byte)index;
        }
    }
}

