/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.DateUtils;
import com.acgist.snail.utils.PropertyDescriptor;
import com.acgist.snail.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class BeanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

    private BeanUtils() {
    }

    public static final <T> T newInstance(Class<T> clazz) {
        Objects.requireNonNull(clazz, "\u65e0\u6548\u7c7b\u578b");
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error("\u901a\u8fc7\u53cd\u5c04\u751f\u6210\u5b9e\u4f8b\u5f02\u5e38\uff1a{}", clazz, e);
            return null;
        }
    }

    public static final Object objectToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Enum) {
            Enum value = (Enum)object;
            return value.name();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return DateUtils.dateFormat(date);
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return StringUtils.hex(bytes);
        }
        return object;
    }

    public static final String toString(Object instance, Object ... values) {
        if (instance == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(instance.getClass().getSimpleName());
        builder.append("@");
        if (ArrayUtils.isEmpty(values)) {
            builder.append(BeanUtils.toMap(instance).toString());
        } else {
            builder.append("{");
            for (Object object : values) {
                builder.append(BeanUtils.objectToString(object)).append(", ");
            }
            builder.setLength(builder.length() - 2);
            builder.append("}");
        }
        return builder.toString();
    }

    public static final Map<String, Object> toMap(Object instance) {
        if (instance == null) {
            return Map.of();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] properties = BeanUtils.properties(instance.getClass());
        PropertyDescriptor descriptor = PropertyDescriptor.newInstance(instance);
        for (String property : properties) {
            map.put(property, BeanUtils.objectToString(descriptor.get(property)));
        }
        return map;
    }

    public static final String[] properties(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        String[] properties = null;
        Class<?> superClazz = clazz.getSuperclass();
        properties = superClazz != null ? BeanUtils.properties(superClazz) : new String[]{};
        Field[] fields = clazz.getDeclaredFields();
        return (String[])Stream.concat(Stream.of(fields).filter(field -> !PropertyDescriptor.ignoreProperty(field)).map(Field::getName), Stream.of(properties)).toArray(String[]::new);
    }

    public static final Object[] properties(Object instance, String[] properties) {
        Objects.requireNonNull(instance);
        Objects.requireNonNull(properties);
        PropertyDescriptor descriptor = PropertyDescriptor.newInstance(instance);
        return Stream.of(properties).map(descriptor::get).toArray();
    }

    public static final void properties(Object instance, Map<String, Object> properties) {
        Objects.requireNonNull(instance);
        Objects.requireNonNull(properties);
        PropertyDescriptor descriptor = PropertyDescriptor.newInstance(instance);
        properties.forEach(descriptor::set);
    }
}

