/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.utils.NumberUtils;
import java.util.BitSet;

public final class BitfieldUtils {
    private BitfieldUtils() {
    }

    public static final byte[] toBytes(int pieceSize, BitSet pieces) {
        byte[] value = pieces.toByteArray();
        for (int index = 0; index < value.length; ++index) {
            value[index] = BitfieldUtils.reverse(value[index]);
        }
        int byteSize = NumberUtils.ceilDiv(pieceSize, 8);
        byte[] bitfield = new byte[byteSize];
        System.arraycopy(value, 0, bitfield, 0, value.length);
        return bitfield;
    }

    public static final BitSet toBitSet(byte[] bitfield) {
        for (int index = 0; index < bitfield.length; ++index) {
            bitfield[index] = BitfieldUtils.reverse(bitfield[index]);
        }
        return BitSet.valueOf(bitfield);
    }

    private static final byte reverse(byte value) {
        int result = value;
        result = (result & 0xF0) >> 4 | (result & 0xF) << 4;
        result = (result & 0xCC) >> 2 | (result & 0x33) << 2;
        result = (result & 0xAA) >> 1 | (result & 0x55) << 1;
        return (byte)result;
    }
}

