/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class DateUtils {
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final long WINDOWS_JAVA_DIFF_TIMEMILLIS = 11644473600000L;
    private static final int UNIX_TIMESTAMP_SCALE = 1000;
    private static final int WINDOWS_TIMESTAMP_SCALE = 10000;

    private DateUtils() {
    }

    public static final String format(long seconds) {
        long minutes;
        long hours;
        TimeUnit secondUnit = TimeUnit.SECONDS;
        StringBuilder builder = new StringBuilder();
        long days = secondUnit.toDays(seconds);
        if (days != 0L) {
            builder.append(days).append("\u5929");
            seconds -= TimeUnit.DAYS.toSeconds(days);
        }
        if ((hours = secondUnit.toHours(seconds)) != 0L) {
            builder.append(hours).append("\u5c0f\u65f6");
            if (days != 0L) {
                return builder.toString();
            }
            seconds -= TimeUnit.HOURS.toSeconds(hours);
        }
        if ((minutes = secondUnit.toMinutes(seconds)) != 0L) {
            builder.append(minutes).append("\u5206\u949f");
            if (hours != 0L) {
                return builder.toString();
            }
            seconds -= TimeUnit.MINUTES.toSeconds(minutes);
        }
        builder.append(seconds).append("\u79d2");
        return builder.toString();
    }

    public static final String dateFormat(Date date) {
        return DateUtils.dateFormat(date, DEFAULT_PATTERN);
    }

    public static final String dateFormat(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        return DateUtils.localDateTimeFormat(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), pattern);
    }

    public static final String localDateTimeFormat(LocalDateTime localDateTime) {
        return DateUtils.localDateTimeFormat(localDateTime, DEFAULT_PATTERN);
    }

    public static final String localDateTimeFormat(LocalDateTime localDateTime, String pattern) {
        if (localDateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DEFAULT_PATTERN.equals(pattern) || pattern == null ? DEFAULT_FORMATTER : DateTimeFormatter.ofPattern(pattern);
        return formatter.format(localDateTime);
    }

    public static final long unixTimestamp() {
        return DateUtils.unixTimestamp(System.currentTimeMillis());
    }

    public static final long unixTimestamp(long timestamp) {
        return timestamp / 1000L;
    }

    public static final long unixToJavaTimestamp(long unixTimestamp) {
        return unixTimestamp * 1000L;
    }

    public static final Date unixToJavaDate(long unixTimestamp) {
        return new Date(DateUtils.unixToJavaTimestamp(unixTimestamp));
    }

    public static final long windowsTimestamp() {
        return DateUtils.windowsTimestamp(System.currentTimeMillis());
    }

    public static final long windowsTimestamp(long timestamp) {
        return (timestamp + 11644473600000L) * 10000L;
    }

    public static final long windowsToJavaTimestamp(long windowsTimestamp) {
        return windowsTimestamp / 10000L - 11644473600000L;
    }

    public static final Date windowsToJavaDate(long windowsTimestamp) {
        return new Date(DateUtils.windowsToJavaTimestamp(windowsTimestamp));
    }

    public static final int timestampUs() {
        return (int)(System.nanoTime() / 1000L);
    }
}

