/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.utils.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestUtils {
    public static final String ALGO_MD5 = "MD5";
    public static final String ALGO_SHA1 = "SHA-1";

    private DigestUtils() {
    }

    public static final MessageDigest md5() {
        return DigestUtils.digest(ALGO_MD5);
    }

    public static final MessageDigest sha1() {
        return DigestUtils.digest(ALGO_SHA1);
    }

    public static final MessageDigest digest(String algo) {
        try {
            return MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6563\u5217\u7b97\u6cd5\uff1a" + algo, e);
        }
    }

    public static final byte[] md5(byte[] bytes) {
        return DigestUtils.md5().digest(bytes);
    }

    public static final String md5Hex(String value) {
        return StringUtils.hex(DigestUtils.md5(value.getBytes()));
    }

    public static final byte[] sha1(byte[] bytes) {
        return DigestUtils.sha1().digest(bytes);
    }

    public static final String sha1Hex(String value) {
        return StringUtils.hex(DigestUtils.sha1(value.getBytes()));
    }
}

