/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static final <T> T[] index(Class<T> clazz, Function<T, Byte> mapper) {
        if (clazz == null || !clazz.isEnum()) {
            throw new IllegalArgumentException("\u5fc5\u987b\u8f93\u5165\u679a\u4e3e\u7c7b\u578b");
        }
        T[] array = clazz.getEnumConstants();
        int length = Stream.of(array).map(mapper::apply).map(v -> Byte.toUnsignedInt(v)).max(Integer::compare).get() + 1;
        if (array.length * 2 < length || 127 < length) {
            throw new IllegalArgumentException("\u679a\u4e3e\u7c7b\u578b\u4e0d\u9002\u5408\u5efa\u7d22\u5f15");
        }
        Object[] index = (Object[])Array.newInstance(clazz, length);
        for (T value : array) {
            index[mapper.apply(value).byteValue()] = value;
        }
        return index;
    }

    public static final <T> Map<Integer, T> map(Class<T> clazz, Function<T, Integer> mapper) {
        if (clazz == null || !clazz.isEnum()) {
            throw new IllegalArgumentException("\u5fc5\u987b\u8f93\u5165\u679a\u4e3e\u7c7b\u578b");
        }
        T[] array = clazz.getEnumConstants();
        return Stream.of(array).collect(Collectors.toMap(v -> (Integer)mapper.apply(v), UnaryOperator.identity()));
    }
}

