/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.context.ITaskSession;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.DigestUtils;
import com.acgist.snail.utils.StringUtils;
import com.acgist.snail.utils.UrlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String[] FILE_SCALE_UNIT = new String[]{"B", "KB", "M", "G", "T"};
    private static final String FILENAME_REPLACE_REGEX = "[:/\\\\\\*\\?\\<\\>\\|]";
    private static final Map<ITaskSession.FileType, List<String>> FILE_TYPE_EXT = new EnumMap<ITaskSession.FileType, List<String>>(ITaskSession.FileType.class);

    private FileUtils() {
    }

    public static final String systemSeparator(String path) {
        if (path == null) {
            return path;
        }
        return path.replace(SymbolConfig.Symbol.SLASH.toChar(), File.separatorChar).replace(SymbolConfig.Symbol.BACKSLASH.toChar(), File.separatorChar);
    }

    public static final void delete(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            LOGGER.warn("\u5220\u9664\u6587\u4ef6\u4e3a\u7a7a\uff1a{}", filePath);
            return;
        }
        FileUtils.delete(new File(filePath));
    }

    public static final void delete(File file) {
        if (file == null || !file.exists()) {
            LOGGER.debug("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a{}", file);
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File children : files = file.listFiles()) {
                FileUtils.delete(children);
            }
        }
        LOGGER.info("\u5220\u9664\u6587\u4ef6\uff1a{}", file);
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            LOGGER.error("\u5220\u9664\u6587\u4ef6\u5f02\u5e38\uff1a{}", file, e);
        }
    }

    public static final String fileName(String url) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        String fileName = UrlUtils.decode(url);
        char slash = SymbolConfig.Symbol.SLASH.toChar();
        char backslash = SymbolConfig.Symbol.BACKSLASH.toChar();
        int index = fileName.indexOf(backslash);
        if (index != -1) {
            fileName = fileName.replace(backslash, slash);
        }
        if ((index = fileName.lastIndexOf(slash)) != -1) {
            fileName = fileName.substring(index + 1);
        }
        if ((index = fileName.indexOf(SymbolConfig.Symbol.QUESTION.toChar())) != -1) {
            fileName = fileName.substring(0, index);
        }
        if ((index = fileName.indexOf(SymbolConfig.Symbol.POUND.toChar())) != -1) {
            fileName = fileName.substring(0, index);
        }
        fileName = fileName.replaceAll(FILENAME_REPLACE_REGEX, "");
        if ((fileName = fileName.strip()).isEmpty()) {
            LOGGER.warn("\u6587\u4ef6\u540d\u79f0\u9519\u8bef\uff1a{} - {}", fileName, url);
        }
        return fileName;
    }

    public static final ITaskSession.FileType fileType(String fileName) {
        String ext = FileUtils.fileExt(fileName);
        if (ext == null) {
            return ITaskSession.FileType.UNKNOWN;
        }
        String extLower = ext.toLowerCase();
        return FILE_TYPE_EXT.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(extLower)).map(Map.Entry::getKey).findFirst().orElse(ITaskSession.FileType.UNKNOWN);
    }

    public static final String fileExt(String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            return null;
        }
        int index = fileName.lastIndexOf(SymbolConfig.Symbol.DOT.toChar());
        if (index < 0) {
            return null;
        }
        return fileName.substring(index + 1);
    }

    public static final void write(String filePath, byte[] bytes) {
        FileUtils.buildParentFolder(filePath);
        try (FileOutputStream output = new FileOutputStream(filePath);){
            ((OutputStream)output).write(bytes);
        }
        catch (IOException e) {
            LOGGER.error("\u6587\u4ef6\u5199\u5165\u5f02\u5e38\uff1a{}", filePath, e);
        }
    }

    public static final void move(String source, String target) {
        FileUtils.buildParentFolder(target);
        File sourceFile = new File(source);
        File targetFile = new File(target);
        if (!sourceFile.renameTo(targetFile)) {
            LOGGER.warn("\u6587\u4ef6\u79fb\u52a8\u5931\u8d25\uff0c\u539f\u59cb\u6587\u4ef6\uff1a{}\uff0c\u76ee\u6807\u6587\u4ef6\uff1a{}", source, target);
        }
    }

    public static final void copy(String source, String target) {
        FileUtils.buildParentFolder(target);
        try (FileInputStream input = new FileInputStream(source);
             FileOutputStream output = new FileOutputStream(target);){
            ((InputStream)input).transferTo(output);
        }
        catch (IOException e) {
            LOGGER.error("\u6587\u4ef6\u62f7\u8d1d\u5f02\u5e38\uff0c\u539f\u59cb\u6587\u4ef6\uff1a{}\uff0c\u76ee\u6807\u6587\u4ef6\uff1a{}", source, target, e);
        }
    }

    public static final String file(String folder, String fileName) {
        Objects.requireNonNull(folder, "\u6587\u4ef6\u76ee\u5f55\u683c\u5f0f\u9519\u8bef");
        Objects.requireNonNull(fileName, "\u6587\u4ef6\u540d\u79f0\u683c\u5f0f\u9519\u8bef");
        return Paths.get(folder, fileName).toString();
    }

    public static final String formatSize(Long size) {
        double value;
        if (size == null || size <= 0L) {
            return "0B";
        }
        int index = 0;
        for (value = (double)size.longValue(); value >= 1024.0; value /= 1024.0) {
            if (++index < FILE_SCALE_UNIT.length) continue;
            index = FILE_SCALE_UNIT.length - 1;
            break;
        }
        return BigDecimal.valueOf(value).setScale(2, RoundingMode.HALF_UP) + FILE_SCALE_UNIT[index];
    }

    public static final double formatSizeMB(Long size) {
        if (size == null || size <= 0L) {
            return 0.0;
        }
        return BigDecimal.valueOf(size).divide(BigDecimal.valueOf(0x100000L)).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static final String formatSpeed(Long size) {
        return FileUtils.formatSize(size) + "/S";
    }

    public static final long fileSize(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return 0L;
        }
        long size = 0L;
        if (file.isFile()) {
            try {
                size = Files.size(file.toPath());
            }
            catch (IOException e) {
                LOGGER.error("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38\uff1a{}", file, e);
            }
        } else {
            File[] files;
            for (File children : files = file.listFiles()) {
                size += FileUtils.fileSize(children.getAbsolutePath());
            }
        }
        return size;
    }

    public static final void buildParentFolder(String path) {
        FileUtils.buildParentFolder(new File(path));
    }

    public static final void buildFolder(String path) {
        FileUtils.buildFolder(new File(path));
    }

    public static final void buildParentFolder(File file) {
        FileUtils.buildFolder(file.getParentFile());
    }

    public static final void buildFolder(File file) {
        if (file == null || file.exists()) {
            return;
        }
        file.mkdirs();
    }

    public static final String md5(String path) {
        return FileUtils.hash(path, "MD5");
    }

    public static final String sha1(String path) {
        return FileUtils.hash(path, "SHA-1");
    }

    private static final String hash(String path, String algo) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(algo);
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        byte[] bytes = new byte[16384];
        MessageDigest digest = DigestUtils.digest(algo);
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
            int length;
            while ((length = ((InputStream)input).read(bytes)) != -1) {
                digest.update(bytes, 0, length);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u8ba1\u7b97\u6587\u4ef6\u6563\u5217\u503c\u5f02\u5e38\uff1a{} - {}", algo, path, e);
        }
        return StringUtils.hex(digest.digest());
    }

    public static final String userDir() {
        return USER_DIR;
    }

    public static final String userDir(String path) {
        return FileUtils.file(FileUtils.userDir(), path);
    }

    public static final File userDirFile(String path) {
        return new File(FileUtils.userDir(path));
    }

    public static final String tempDir() {
        return TEMP_DIR;
    }

    static {
        FILE_TYPE_EXT.put(ITaskSession.FileType.IMAGE, List.of("bmp", "cdr", "gif", "ico", "jpeg", "jpg", "png", "psd", "svg", "webp"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.VIDEO, List.of("3gp", "avi", "flv", "m3u", "m3u8", "mkv", "mov", "mp4", "mpeg", "mvb", "rm", "rmvb", "wmv"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.AUDIO, List.of("aac", "flac", "m4a", "mp3", "ogg", "wav", "wma"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.SCRIPT, List.of("asp", "bat", "c", "cmd", "cpp", "h", "java", "js", "jsp", "php", "py", "sh", "sql"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.TORRENT, List.of("torrent"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.COMPRESS, List.of("7z", "bz2", "dmg", "gz", "iso", "jar", "rar", "tar", "z", "zip"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.DOCUMENT, List.of("css", "csv", "doc", "docx", "htm", "html", "json", "log", "md", "pdf", "ppt", "pptx", "txt", "wps", "xls", "xlsx", "xml"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.INSTALL, List.of("apk", "hap", "msi", "exe", "pkg", "dmg", "deb", "rpm", "sis", "sisx"));
        FILE_TYPE_EXT.put(ITaskSession.FileType.UNKNOWN, List.of());
        LOGGER.debug("\u7528\u6237\u5de5\u4f5c\u76ee\u5f55\uff1a{}", FileUtils.userDir());
        LOGGER.debug("\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55\uff1a{}", FileUtils.tempDir());
    }
}

