/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.utils.CollectionUtils;
import com.acgist.snail.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ListUtils {
    private ListUtils() {
    }

    public static final <T> T first(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static final <T> T last(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static final <T> T get(List<T> list, int index) {
        if (ListUtils.badIndex(list, index)) {
            return null;
        }
        return list.get(index);
    }

    public static final Byte getByte(List<?> list, int index) {
        Long value = ListUtils.getLong(list, index);
        if (value == null) {
            return null;
        }
        return value.byteValue();
    }

    public static final Integer getInteger(List<?> list, int index) {
        Long value = ListUtils.getLong(list, index);
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public static final Long getLong(List<?> list, int index) {
        if (ListUtils.badIndex(list, index)) {
            return null;
        }
        return (Long)list.get(index);
    }

    public static final String getString(List<?> list, int index) {
        return ListUtils.getString(list, index, null);
    }

    public static final String getString(List<?> list, int index, String encoding) {
        byte[] bytes = ListUtils.getBytes(list, index);
        if (bytes == null) {
            return null;
        }
        return StringUtils.getCharsetString(bytes, encoding);
    }

    public static final byte[] getBytes(List<?> list, int index) {
        if (ListUtils.badIndex(list, index)) {
            return null;
        }
        return (byte[])list.get(index);
    }

    public static final List<Object> getList(List<?> list, int index) {
        if (ListUtils.badIndex(list, index)) {
            return List.of();
        }
        List result = (List)list.get(index);
        if (result == null) {
            return List.of();
        }
        return result.stream().collect(Collectors.toList());
    }

    public static final Map<String, Object> getMap(List<?> list, int index) {
        if (ListUtils.badIndex(list, index)) {
            return Map.of();
        }
        Map result = (Map)list.get(index);
        if (result == null) {
            return Map.of();
        }
        return result.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    private static final boolean badIndex(List<?> list, int index) {
        return list == null || list.size() <= index;
    }
}

