/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.utils.StringUtils;
import com.acgist.snail.utils.UrlUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MapUtils {
    private MapUtils() {
    }

    public static final boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static final boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtils.isEmpty(map);
    }

    public static final Map<String, String> ofUrlQuery(String query) {
        if (query == null) {
            return Map.of();
        }
        char equals = SymbolConfig.Symbol.EQUALS.toChar();
        return Stream.of(SymbolConfig.Symbol.AND.split(query)).map(v -> {
            int index = v.indexOf(equals);
            if (index < 0) {
                return new String[]{v, ""};
            }
            return new String[]{v.substring(0, index), UrlUtils.decode(v.substring(index + 1))};
        }).collect(Collectors.toMap(v -> v[0], v -> v[1]));
    }

    public static final String toUrlQuery(Map<String, String> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        return map.entrySet().stream().map(entry -> SymbolConfig.Symbol.EQUALS.join((String)entry.getKey(), UrlUtils.encode((String)entry.getValue()))).collect(Collectors.joining(SymbolConfig.Symbol.AND.toString()));
    }

    public static final Object get(Map<?, ?> map, String key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static final Byte getByte(Map<?, ?> map, String key) {
        Long value = MapUtils.getLong(map, key);
        if (value == null) {
            return null;
        }
        return value.byteValue();
    }

    public static final Integer getInteger(Map<?, ?> map, String key) {
        Long value = MapUtils.getLong(map, key);
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public static final Long getLong(Map<?, ?> map, String key) {
        if (map == null) {
            return null;
        }
        return (Long)map.get(key);
    }

    public static final String getString(Map<?, ?> map, String key) {
        return MapUtils.getString(map, key, null);
    }

    public static final String getString(Map<?, ?> map, String key, String encoding) {
        byte[] bytes = MapUtils.getBytes(map, key);
        if (bytes == null) {
            return null;
        }
        return StringUtils.getCharsetString(bytes, encoding);
    }

    public static final byte[] getBytes(Map<?, ?> map, String key) {
        if (map == null) {
            return null;
        }
        return (byte[])map.get(key);
    }

    public static final List<Object> getList(Map<?, ?> map, String key) {
        if (map == null) {
            return List.of();
        }
        List result = (List)map.get(key);
        if (result == null) {
            return List.of();
        }
        return result.stream().collect(Collectors.toList());
    }

    public static final Map<String, Object> getMap(Map<?, ?> map, String key) {
        if (map == null) {
            return Map.of();
        }
        Map result = (Map)map.get(key);
        if (result == null) {
            return Map.of();
        }
        return result.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }
}

