/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.ModifyOptional;
import com.acgist.snail.utils.NumberUtils;
import com.acgist.snail.utils.StringUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringTokenizer;

public final class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);
    public static final String LOCAL_HOST_NAME;
    public static final String LOCAL_HOST_ADDRESS;
    public static final short LOCAL_PREFIX_LENGTH;
    public static final String LOOPBACK_HOST_NAME;
    public static final String LOOPBACK_HOST_ADDRESS;
    public static final NetworkInterface DEFAULT_NETWORK_INTERFACE;
    public static final StandardProtocolFamily LOCAL_PROTOCOL_FAMILY;
    public static final int MAX_PORT = 65536;
    private static final int AREA_IP = 256;
    private static final String IPV4_REGEX = "(\\d{1,3}\\.){3}\\d{1,3}";
    private static final String IPV6_REGEX = "((([0-9a-f]{1,4}(:|::))|(::)){0,7}){1}(([0-9a-f]{1,4})|(\\d{1,3}\\.){3}\\d{1,3})?(/\\d{0,3})?(%.+)?";
    private static final String ADAPTER = "Adapter";

    private NetUtils() {
    }

    public static final boolean available(NetworkInterface networkInterface) {
        try {
            return networkInterface.isUp() && !networkInterface.isVirtual() && !networkInterface.isLoopback() && !networkInterface.isPointToPoint() && !networkInterface.getDisplayName().contains(ADAPTER);
        }
        catch (SocketException e) {
            LOGGER.error("\u83b7\u53d6\u7f51\u5361\u72b6\u6001\u5f02\u5e38", e);
            return false;
        }
    }

    public static final boolean localIPv4() {
        return LOCAL_PROTOCOL_FAMILY == StandardProtocolFamily.INET;
    }

    public static final short portToShort(int port) {
        return (short)port;
    }

    public static final int portToInt(short port) {
        return Short.toUnsignedInt(port);
    }

    public static final int ipToInt(String ip) {
        Objects.requireNonNull(ip, "IP\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        int index = 0;
        byte[] bytes = new byte[4];
        StringTokenizer tokenizer = new StringTokenizer(ip, SymbolConfig.Symbol.DOT.toString());
        while (tokenizer.hasMoreTokens()) {
            if (bytes.length <= index) {
                throw new IllegalArgumentException("IP\u5730\u5740\u9519\u8bef\uff1a" + ip);
            }
            bytes[index++] = (byte)Short.parseShort(tokenizer.nextToken());
        }
        return NumberUtils.bytesToInt(bytes);
    }

    public static final String intToIP(int ip) {
        byte[] bytes = NumberUtils.intToBytes(ip);
        StringBuilder builder = new StringBuilder();
        builder.append(Byte.toUnsignedInt(bytes[0])).append(SymbolConfig.Symbol.DOT.toString()).append(Byte.toUnsignedInt(bytes[1])).append(SymbolConfig.Symbol.DOT.toString()).append(Byte.toUnsignedInt(bytes[2])).append(SymbolConfig.Symbol.DOT.toString()).append(Byte.toUnsignedInt(bytes[3]));
        return builder.toString();
    }

    public static final byte[] ipToBytes(String ip) {
        if (ip == null) {
            return null;
        }
        try {
            return InetAddress.getByName(ip).getAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error("IP\u5730\u5740\u7f16\u7801\u5f02\u5e38\uff1a{}", ip, e);
            return null;
        }
    }

    public static final String bytesToIP(byte[] value) {
        if (value == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(value).getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error("IP\u5730\u5740\u89e3\u7801\u5f02\u5e38", e);
            return null;
        }
    }

    public static final byte[] bufferToIPv6(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        byte[] bytes = new byte[16];
        buffer.get(bytes);
        return bytes;
    }

    public static final boolean ip(String host) {
        return NetUtils.ipv4(host) || NetUtils.ipv6(host);
    }

    public static final boolean ipv4(String host) {
        return StringUtils.regex(host, IPV4_REGEX, true);
    }

    public static final boolean ipv6(String host) {
        return StringUtils.regex(host, IPV6_REGEX, true);
    }

    public static final boolean lan(String host) {
        if (NetUtils.ip(host)) {
            byte[] localHostBytes;
            byte[] remoteHostBytes = NetUtils.ipToBytes(host);
            int index = Arrays.mismatch(remoteHostBytes, localHostBytes = NetUtils.ipToBytes(LOCAL_HOST_ADDRESS));
            if (index == -1) {
                return true;
            }
            return index * 8 >= LOCAL_PREFIX_LENGTH;
        }
        return false;
    }

    public static final boolean localIP(String host) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            LOGGER.error("IP\u5730\u5740\u8f6c\u6362\u5f02\u5e38\uff1a{}", host, e);
            return true;
        }
        return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isMulticastAddress() || inetAddress.isSiteLocalAddress();
    }

    public static final boolean areaIP(String source, String target) {
        int targetIp;
        int sourceIp = NetUtils.ipToInt(source);
        return (sourceIp ^ (targetIp = NetUtils.ipToInt(target))) <= 256;
    }

    public static final InetSocketAddress buildSocketAddress(int port) {
        return NetUtils.buildSocketAddress(null, port);
    }

    public static final InetSocketAddress buildSocketAddress(String host, int port) {
        if (StringUtils.isEmpty(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(host, port);
    }

    public static final String buildLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.error("\u83b7\u53d6\u672c\u673a\u540d\u79f0\u5f02\u5e38", e);
            return null;
        }
    }

    public static final String buildLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error("\u83b7\u53d6\u672c\u673a\u5730\u5740\u5f02\u5e38", e);
            return null;
        }
    }

    public static final String buildLoopbackHostName() {
        return InetAddress.getLoopbackAddress().getHostName();
    }

    public static final String buildLoopbackHostAddress() {
        return InetAddress.getLoopbackAddress().getHostAddress();
    }

    static {
        ModifyOptional<Short> localPrefixLength = ModifyOptional.newInstance();
        ModifyOptional<String> localHostAddress = ModifyOptional.newInstance();
        ModifyOptional defaultNetworkInterface = ModifyOptional.newInstance();
        try {
            NetworkInterface.networkInterfaces().filter(NetUtils::available).sorted((source, target) -> Integer.compare(target.getIndex(), source.getIndex())).findFirst().ifPresent(networkInterface -> networkInterface.getInterfaceAddresses().forEach(interfaceAddress -> {
                InetAddress address = interfaceAddress.getAddress();
                String hostAddress = address.getHostAddress();
                short networkPrefixLength = interfaceAddress.getNetworkPrefixLength();
                if (!(address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isMulticastAddress())) {
                    localHostAddress.set(hostAddress);
                    localPrefixLength.set(networkPrefixLength);
                    defaultNetworkInterface.set(networkInterface);
                }
            }));
        }
        catch (SocketException e) {
            LOGGER.error("\u521d\u59cb\u5316\u672c\u673a\u7f51\u7edc\u4fe1\u606f\u5f02\u5e38", e);
        }
        LOCAL_HOST_NAME = NetUtils.buildLocalHostName();
        LOCAL_HOST_ADDRESS = localHostAddress.get(NetUtils.buildLocalHostAddress());
        LOOPBACK_HOST_NAME = NetUtils.buildLoopbackHostName();
        LOOPBACK_HOST_ADDRESS = NetUtils.buildLoopbackHostAddress();
        LOCAL_PREFIX_LENGTH = localPrefixLength.get((short)24);
        DEFAULT_NETWORK_INTERFACE = (NetworkInterface)defaultNetworkInterface.get();
        LOCAL_PROTOCOL_FAMILY = NetUtils.ipv4(LOCAL_HOST_ADDRESS) ? StandardProtocolFamily.INET : StandardProtocolFamily.INET6;
        LOGGER.debug("\u672c\u673a\u540d\u79f0\uff1a{}", LOCAL_HOST_NAME);
        LOGGER.debug("\u672c\u673a\u5730\u5740\uff1a{}", LOCAL_HOST_ADDRESS);
        LOGGER.debug("\u672c\u673a\u73af\u56de\u540d\u79f0\uff1a{}", LOOPBACK_HOST_NAME);
        LOGGER.debug("\u672c\u673a\u73af\u56de\u5730\u5740\uff1a{}", LOOPBACK_HOST_ADDRESS);
        LOGGER.debug("\u672c\u673a\u5b50\u7f51\u524d\u7f00\uff1a{}", LOCAL_PREFIX_LENGTH);
        LOGGER.debug("\u672c\u673aIP\u5730\u5740\u534f\u8bae\uff1a{}", LOCAL_PROTOCOL_FAMILY);
        LOGGER.debug("\u672c\u673a\u9ed8\u8ba4\u7269\u7406\u7f51\u5361\uff1a{}", DEFAULT_NETWORK_INTERFACE);
    }
}

