/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.utils.DateUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;

public final class NumberUtils {
    private static final int MIN_INDEX = 1000;
    private static final int MAX_INDEX = 9999;
    private static int index = (int)(System.currentTimeMillis() % 8999L + 1000L);

    private NumberUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Integer build() {
        StringBuilder builder = new StringBuilder();
        Class<NumberUtils> clazz = NumberUtils.class;
        synchronized (NumberUtils.class) {
            int index = NumberUtils.index;
            builder.append(index);
            if (++index > 9999) {
                index = 1000;
            }
            NumberUtils.index = index;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            builder.append(DateUtils.dateFormat(new Date(), "HHmm"));
            return Integer.valueOf(builder.toString());
        }
    }

    public static final long bytesToLong(byte[] bytes) {
        long value = 0L;
        value |= ((long)bytes[0] & 0xFFL) << 56;
        value |= ((long)bytes[1] & 0xFFL) << 48;
        value |= ((long)bytes[2] & 0xFFL) << 40;
        value |= ((long)bytes[3] & 0xFFL) << 32;
        value |= ((long)bytes[4] & 0xFFL) << 24;
        value |= ((long)bytes[5] & 0xFFL) << 16;
        value |= ((long)bytes[6] & 0xFFL) << 8;
        return value |= (long)bytes[7] & 0xFFL;
    }

    public static final byte[] longToBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    public static final int bytesToInt(byte[] bytes) {
        int value = 0;
        value |= (bytes[0] & 0xFF) << 24;
        value |= (bytes[1] & 0xFF) << 16;
        value |= (bytes[2] & 0xFF) << 8;
        return value |= bytes[3] & 0xFF;
    }

    public static final byte[] intToBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    public static final short bytesToShort(byte[] bytes) {
        short value = 0;
        value = (short)(value | (bytes[0] & 0xFF) << 8);
        value = (short)(value | bytes[1] & 0xFF);
        return value;
    }

    public static final byte[] shortToBytes(short value) {
        byte[] bytes = new byte[]{(byte)(value >>> 8), (byte)value};
        return bytes;
    }

    public static final int ceilDiv(int dividend, int divisor) {
        int value = dividend / divisor;
        if (dividend % divisor != 0) {
            ++value;
        }
        return value;
    }

    public static final int ceilMult(int dividend, int divisor) {
        return NumberUtils.ceilDiv(dividend, divisor) * divisor;
    }

    public static final byte[] encodeBigInteger(BigInteger value, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("\u6570\u7ec4\u957f\u5ea6\u9519\u8bef\uff1a" + length);
        }
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length < length) {
            byte[] copy = bytes;
            bytes = new byte[length];
            System.arraycopy(copy, 0, bytes, bytes.length - copy.length, copy.length);
        }
        return bytes;
    }

    public static final BigInteger decodeBigInteger(ByteBuffer buffer, int length) {
        byte nonzero;
        if (length < 1 || buffer.remaining() < length) {
            throw new IllegalArgumentException("\u6570\u7ec4\u957f\u5ea6\u9519\u8bef\uff1a" + length);
        }
        int index = 0;
        while ((nonzero = buffer.get()) == 0 && ++index < length) {
        }
        if (index == length) {
            return BigInteger.ZERO;
        }
        int newLength = length - index;
        byte[] bytes = new byte[newLength];
        bytes[0] = nonzero;
        buffer.get(bytes, 1, newLength - 1);
        return new BigInteger(1, bytes);
    }

    public static final boolean equals(Number source, Number target) {
        return source == null ? target == null : source.equals(target);
    }

    public static final SecureRandom random() {
        return new SecureRandom();
    }
}

