/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.ArrayUtils;
import com.acgist.snail.utils.DigestUtils;
import com.acgist.snail.utils.MapUtils;
import com.acgist.snail.utils.NetUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class PeerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerUtils.class);
    private static final int ALLOWED_FAST_K = 10;
    private static final int ALLOWED_FAST_IP_MASK = -256;
    private static final int ALLOWED_FAST_LOOP_LENGTH = 5;

    private PeerUtils() {
    }

    public static final Map<String, Integer> readIPv4(byte[] bytes) {
        if (bytes == null) {
            return Map.of();
        }
        return PeerUtils.readIPv4(ByteBuffer.wrap(bytes));
    }

    public static final Map<String, Integer> readIPv4(ByteBuffer buffer) {
        if (buffer == null) {
            return Map.of();
        }
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        while (buffer.remaining() >= 6) {
            String ip = NetUtils.intToIP(buffer.getInt());
            int port = NetUtils.portToInt(buffer.getShort());
            data.put(ip, port);
        }
        return data;
    }

    public static final Map<String, Integer> readIPv6(byte[] bytes) {
        if (bytes == null) {
            return Map.of();
        }
        return PeerUtils.readIPv6(ByteBuffer.wrap(bytes));
    }

    public static final Map<String, Integer> readIPv6(ByteBuffer buffer) {
        if (buffer == null) {
            return Map.of();
        }
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        while (buffer.remaining() >= 18) {
            byte[] bytes = NetUtils.bufferToIPv6(buffer);
            String ip = NetUtils.bytesToIP(bytes);
            int port = NetUtils.portToInt(buffer.getShort());
            data.put(ip, port);
        }
        return data;
    }

    public static final Map<String, Integer> read(List<?> list) {
        if (list == null) {
            return Map.of();
        }
        return list.stream().filter(Objects::nonNull).map(value -> {
            Map map = (Map)value;
            return Map.entry(MapUtils.getString(map, "ip"), MapUtils.getInteger(map, "port"));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static final Map<String, Integer> readIPv4(Object object) {
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return PeerUtils.readIPv4(bytes);
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)object;
            return PeerUtils.readIPv4(buffer);
        }
        if (object instanceof List) {
            List list = (List)object;
            return PeerUtils.read(list);
        }
        LOGGER.debug("Peer\u58f0\u660e\u6d88\u606f\u683c\u5f0f\u6ca1\u6709\u9002\u914d\uff1a{}", object);
        return Map.of();
    }

    public static final Map<String, Integer> readIPv6(Object object) {
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return PeerUtils.readIPv6(bytes);
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)object;
            return PeerUtils.readIPv6(buffer);
        }
        if (object instanceof List) {
            List list = (List)object;
            return PeerUtils.read(list);
        }
        LOGGER.debug("Peer\u58f0\u660e\u6d88\u606f\u683c\u5f0f\u6ca1\u6709\u9002\u914d\uff1a{}", object);
        return Map.of();
    }

    public static final int[] allowedFast(int pieceSize, String ipAddress, byte[] infoHash) {
        int ipValue = NetUtils.ipToInt(ipAddress);
        ByteBuffer buffer = ByteBuffer.allocate(24);
        buffer.putInt(0xFFFFFF00 & ipValue);
        buffer.put(infoHash);
        int size = 0;
        int length = Math.min(10, pieceSize);
        int[] seqs = new int[length];
        while (size < length) {
            buffer = ByteBuffer.wrap(DigestUtils.sha1(buffer.array()));
            for (int index = 0; index < 5 && size < length; ++index) {
                int seq = (int)(Integer.toUnsignedLong(buffer.getInt()) % (long)pieceSize);
                if (ArrayUtils.indexOf(seqs, 0, size, seq) > -1) continue;
                seqs[size++] = seq;
            }
        }
        return seqs;
    }

    public static final String urlEncode(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < bytes.length; ++index) {
            char value = (char)bytes[index];
            if (PeerUtils.noneEncode(value)) {
                builder.append(value);
                continue;
            }
            builder.append(SymbolConfig.Symbol.PERCENT.toString());
            if (value <= '\u000f') {
                builder.append(SymbolConfig.Symbol.ZERO.toString());
            }
            builder.append(Integer.toHexString(value & 0xFF));
        }
        return builder.toString();
    }

    private static final boolean noneEncode(char value) {
        return value >= '0' && value <= '9' || value >= 'a' && value <= 'z' || value >= 'A' && value <= 'Z' || value == '.' || value == '-' || value == '_' || value == '~';
    }
}

