/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.context.SystemThreadContext;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Performance {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final AtomicLong costTime = new AtomicLong();

    protected final void log(Object message) {
        this.log("{}", message);
    }

    protected final void log(String message, Object ... args) {
        this.LOGGER.info(message, args);
    }

    protected final void cost() {
        this.costTime.set(System.currentTimeMillis());
    }

    protected final long costed() {
        long time = System.currentTimeMillis();
        long costed = time - this.costTime.getAndSet(time);
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("\u6d88\u8017\u65f6\u95f4\uff08\u6beb\u79d2-\u79d2\uff09\uff1a{} - {}", costed, costed / 1000L);
        }
        return costed;
    }

    protected final long costed(int count, Coster coster) {
        this.cost();
        for (int index = 0; index < count; ++index) {
            coster.execute();
        }
        return this.costed();
    }

    protected final long costed(int count, int thread, Coster coster) {
        CountDownLatch latch = new CountDownLatch(count);
        ExecutorService executor = SystemThreadContext.newExecutor(thread, thread, count, 60L, "ST-Costed");
        this.cost();
        for (int index = 0; index < count; ++index) {
            executor.submit(() -> {
                try {
                    coster.execute();
                }
                catch (Exception e) {
                    this.LOGGER.error("\u6267\u884c\u4efb\u52a1\u5f02\u5e38", e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.LOGGER.error("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", e);
        }
        long costed = this.costed();
        SystemThreadContext.shutdownNow(executor);
        return costed;
    }

    public static interface Coster {
        public void execute();
    }
}

