/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class PropertyDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyDescriptor.class);
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final Map<Class<?>, Map<String, Method>> CACHE_METHOD = new WeakHashMap();
    private final Class<?> clazz;
    private final Object instance;

    private PropertyDescriptor(Object instance) {
        this.instance = instance;
        this.clazz = instance.getClass();
    }

    public static final PropertyDescriptor newInstance(Object instance) {
        return new PropertyDescriptor(instance);
    }

    public static final boolean ignoreProperty(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
    }

    public Method getter(String property) {
        Method[] methods;
        String getMethod;
        Map map = CACHE_METHOD.computeIfAbsent(this.clazz, key -> new HashMap());
        Method result = (Method)map.get(getMethod = PREFIX_GET + property);
        if (result != null) {
            return result;
        }
        String isMethod = PREFIX_IS + property;
        for (Method method : methods = this.clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getParameterCount() != 0 || !getMethod.equalsIgnoreCase(methodName) && !isMethod.equalsIgnoreCase(methodName) && !property.equalsIgnoreCase(methodName)) continue;
            map.put(getMethod, method);
            return method;
        }
        return null;
    }

    public Object get(String property) {
        Method getter = this.getter(property);
        if (getter == null) {
            return null;
        }
        try {
            return getter.invoke(this.instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.error("\u83b7\u53d6\u5c5e\u6027\u503c\u5f02\u5e38\uff1a{} - {}", this.instance, property, e);
            return null;
        }
    }

    public Method setter(String property) {
        Method[] methods;
        String setMethod;
        Map map = CACHE_METHOD.computeIfAbsent(this.clazz, key -> new HashMap());
        Method result = (Method)map.get(setMethod = PREFIX_SET + property);
        if (result != null) {
            return result;
        }
        for (Method method : methods = this.clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getParameterCount() != 1 || !setMethod.equalsIgnoreCase(methodName) && !property.equalsIgnoreCase(methodName)) continue;
            map.put(setMethod, method);
            return method;
        }
        return null;
    }

    public void set(String property, Object value) {
        Method setter = this.setter(property);
        if (setter == null) {
            return;
        }
        try {
            setter.invoke(this.instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.error("\u8bbe\u7f6e\u5c5e\u6027\u503c\u5f02\u5e38\uff1a{} - {} - {}", this.instance, property, value, e);
        }
    }

    public Class<?> getPropertyType(String property) {
        for (Class<?> superClazz = this.clazz; superClazz != null; superClazz = superClazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = superClazz.getDeclaredFields()) {
                String fieldName = field.getName();
                if (PropertyDescriptor.ignoreProperty(field) || !fieldName.equals(property)) continue;
                return field.getType();
            }
        }
        return null;
    }
}

