/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.utils.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtils.class);
    private static final int HEX_LENGTH = 2;
    private static final int UNICODE_LENGTH = 4;
    private static final String UNICODE_PREFIX = "\\u";
    private static final String UNICODE_REGEX = "\\\\u";
    private static final String BLANK_REGEX = "\\s";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private StringUtils() {
    }

    public static final boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static final boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static final boolean isNumeric(String value) {
        return StringUtils.isNumber(value, false);
    }

    public static final boolean isDecimal(String value) {
        return StringUtils.isNumber(value, true);
    }

    public static final boolean isNumber(String value, boolean decimal) {
        if (value == null) {
            return false;
        }
        char[] chars = value.toCharArray();
        if (chars.length == 0) {
            return false;
        }
        if (chars.length == 1) {
            return Character.isDigit(chars[0]);
        }
        if (!Character.isDigit(chars[0]) && chars[0] != SymbolConfig.Symbol.PLUS.toChar() && chars[0] != SymbolConfig.Symbol.MINUS.toChar()) {
            return false;
        }
        for (int index = 1; index < chars.length; ++index) {
            if (Character.isDigit(chars[index])) continue;
            if (decimal && Character.isDigit(chars[index - 1]) && chars[index] == SymbolConfig.Symbol.DOT.toChar()) {
                decimal = false;
                continue;
            }
            return false;
        }
        return true;
    }

    public static final boolean startsWith(String value, String prefix) {
        return value != null && prefix != null && value.startsWith(prefix);
    }

    public static final boolean startsWithIgnoreCase(String value, String prefix) {
        int prefixLength;
        if (Objects.isNull(value) || Objects.isNull(prefix)) {
            return false;
        }
        int valueLength = value.length();
        if (valueLength < (prefixLength = prefix.length())) {
            return false;
        }
        return StringUtils.equalsIgnoreCase(value.substring(0, prefixLength), prefix);
    }

    public static final boolean endsWith(String value, String suffix) {
        return value != null && suffix != null && value.endsWith(suffix);
    }

    public static final boolean endsWithIgnoreCase(String value, String suffix) {
        int suffixLength;
        if (Objects.isNull(value) || Objects.isNull(suffix)) {
            return false;
        }
        int valueLength = value.length();
        if (valueLength < (suffixLength = suffix.length())) {
            return false;
        }
        return StringUtils.equalsIgnoreCase(value.substring(valueLength - suffixLength), suffix);
    }

    public static final String hex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length << 1];
        for (int index = 0; index < chars.length; index += 2) {
            chars[index] = HEX_CHARS[bytes[index >>> 1] >>> 4 & 0xF];
            chars[index + 1] = HEX_CHARS[bytes[index >>> 1] & 0xF];
        }
        return new String(chars);
    }

    public static final byte[] unhex(String content) {
        if (content == null) {
            return null;
        }
        char[] chars = content.toCharArray();
        int length = chars.length;
        if ((length & 1) != 0) {
            char[] copy = chars;
            chars = new char[length + 1];
            System.arraycopy(copy, 0, chars, 1, length);
            chars[0] = SymbolConfig.Symbol.ZERO.toChar();
            length = chars.length;
        }
        int jndex = 0;
        byte[] bytes = new byte[length >> 1];
        for (int index = 0; index < length; index += 2) {
            bytes[jndex++] = (byte)(Character.digit(chars[index], 16) << 4 & 0xF0 | Character.digit(chars[index + 1], 16) & 0xF);
        }
        return bytes;
    }

    public static final String charsetFrom(String value, String from) {
        return StringUtils.charset(value, from, null);
    }

    public static final String charsetTo(String value, String to) {
        return StringUtils.charset(value, null, to);
    }

    public static final String charset(String value, String from, String to) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        try {
            if (from == null && to == null) {
                return value;
            }
            if (from == null) {
                return new String(value.getBytes(), to);
            }
            if (to == null) {
                return new String(value.getBytes(from));
            }
            return new String(value.getBytes(from), to);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u5b57\u7b26\u4e32\u7f16\u7801\u8f6c\u6362\u5f02\u5e38\uff1a{} - {} - {}", value, from, to, e);
            return value;
        }
    }

    public static final boolean regex(String value, String regex, boolean ignoreCase) {
        if (value == null || regex == null) {
            return false;
        }
        Pattern pattern = ignoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        return pattern.matcher(value).matches();
    }

    public static final boolean equals(String source, String target) {
        if (source == null) {
            return target == null;
        }
        return source.equals(target);
    }

    public static final boolean equalsIgnoreCase(String source, String target) {
        if (source == null) {
            return target == null;
        }
        return source.equalsIgnoreCase(target);
    }

    public static final byte[] toBytes(String message, String charset) {
        if (charset == null) {
            return message.getBytes();
        }
        try {
            return message.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u5b57\u7b26\u7f16\u7801\u5f02\u5e38:{} - {}", charset, message, e);
            return message.getBytes();
        }
    }

    public static final String toUnicode(String content) {
        char[] chars = content.toCharArray();
        String zero = SymbolConfig.Symbol.ZERO.toString();
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < content.length(); ++index) {
            builder.append(UNICODE_PREFIX);
            String hex = Integer.toHexString(chars[index]);
            int length = hex.length();
            if (length < 4) {
                builder.append(zero.repeat(4 - length));
            }
            builder.append(hex);
        }
        return builder.toString();
    }

    public static final String ofUnicode(String unicode) {
        String[] hex = unicode.split(UNICODE_REGEX);
        StringBuilder builder = new StringBuilder();
        for (int index = 1; index < hex.length; ++index) {
            builder.append((char)Integer.parseInt(hex[index], 16));
        }
        return builder.toString();
    }

    public static final String ofByteBuffer(ByteBuffer buffer) {
        return StringUtils.ofByteBuffer(buffer, "UTF-8");
    }

    public static final String ofByteBuffer(ByteBuffer buffer, String charset) {
        if (buffer == null) {
            return null;
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        if (buffer.position() != 0) {
            buffer.flip();
        }
        String content = null;
        CharsetDecoder decoder = Charset.forName(charset).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        try {
            content = decoder.decode(buffer).toString();
            buffer.compact();
        }
        catch (CharacterCodingException e) {
            LOGGER.error("\u5c06ByteBuffer\u8f6c\u4e3a\u5b57\u7b26\u4e32\u5f02\u5e38", e);
        }
        return content;
    }

    public static final String ofInputStream(InputStream input, String charset) {
        if (input == null) {
            return null;
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        char[] chars = new char[1024];
        StringBuilder builder = new StringBuilder();
        try {
            int index;
            InputStreamReader reader = new InputStreamReader(input, charset);
            while ((index = reader.read(chars)) != -1) {
                builder.append(new String(chars, 0, index));
            }
        }
        catch (IOException e) {
            LOGGER.error("\u5c06\u8f93\u5165\u6d41\u8f6c\u4e3a\u5b57\u7b26\u4e32\u5f02\u5e38", e);
        }
        return builder.toString();
    }

    public static final Map<String, String> argsMap(String ... args) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ArrayUtils.isEmpty(args)) {
            return map;
        }
        Properties properties = System.getProperties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(String.valueOf(k), String.valueOf(v))));
        char equals = SymbolConfig.Symbol.EQUALS.toChar();
        for (String arg : args) {
            int index = arg.indexOf(equals);
            if (index < 0) {
                map.put(arg.toLowerCase(), null);
                continue;
            }
            map.put(arg.substring(0, index).strip().toLowerCase(), arg.substring(index + 1).strip());
        }
        return map;
    }

    public static final String getCharset(String content) {
        if (StringUtils.isEmpty(content)) {
            return "UTF-8";
        }
        CharsetEncoder gbkEncoder = Charset.forName("GBK").newEncoder();
        if (gbkEncoder.canEncode(content)) {
            return "UTF-8";
        }
        String gbkContent = StringUtils.charsetTo(content, "GBK");
        if (gbkEncoder.canEncode(gbkContent)) {
            return "GBK";
        }
        return "UTF-8";
    }

    public static final String getString(Object object) {
        return StringUtils.getString(object, null);
    }

    public static final String getString(Object object, String encoding) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            if (encoding != null) {
                try {
                    return new String(bytes, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("\u5b57\u7b26\u7f16\u7801\u5f02\u5e38\uff1a{}", encoding, e);
                }
            }
            return new String(bytes);
        }
        return object.toString();
    }

    public static final String getCharsetString(Object object, String encoding) {
        if (encoding != null) {
            return StringUtils.getString(object, encoding);
        }
        String utf8String = StringUtils.getString(object, encoding);
        String charset = StringUtils.getCharset(utf8String);
        if ("GBK".equals(charset)) {
            return StringUtils.getString(object, "GBK");
        }
        return utf8String;
    }

    public static final String replaceAllBlank(String content) {
        if (content == null) {
            return content;
        }
        return content.replaceAll(BLANK_REGEX, "");
    }

    public static final List<String> readLines(String content) {
        if (content == null) {
            return List.of();
        }
        return Stream.of(content.split(SymbolConfig.Symbol.LINE_SEPARATOR.toString())).map(String::strip).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }
}

