/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import java.util.concurrent.TimeUnit;

public final class ThreadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtils.class);

    private ThreadUtils() {
    }

    public static final void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.debug("\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38", e);
        }
    }

    public static final void sleep(long timeout, TimeUnit unit) {
        try {
            unit.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.debug("\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38", e);
        }
    }

    public static final int activeCount() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup.activeCount();
    }
}

