/*
 * Decompiled with CFR 0.152.
 */
package com.acgist.snail.utils;

import com.acgist.snail.config.SymbolConfig;
import com.acgist.snail.logger.Logger;
import com.acgist.snail.logger.LoggerFactory;
import com.acgist.snail.protocol.Protocol;
import com.acgist.snail.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Objects;

public final class UrlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlUtils.class);

    private UrlUtils() {
    }

    public static final String encode(String content) {
        if (StringUtils.isEmpty(content)) {
            return content;
        }
        try {
            return URLEncoder.encode(content, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("URL\u7f16\u7801\u5f02\u5e38\uff1a{}", content, e);
            return content;
        }
    }

    public static final String decode(String content) {
        if (StringUtils.isEmpty(content)) {
            return content;
        }
        try {
            return URLDecoder.decode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("URL\u89e3\u7801\u5f02\u5e38\uff1a{}", content, e);
            return content;
        }
    }

    public static final String redirect(String source, String target) {
        Objects.requireNonNull(source, "\u539f\u59cb\u9875\u9762\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        Objects.requireNonNull(target, "\u76ee\u6807\u9875\u9762\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        target = target.strip();
        if (target.startsWith(SymbolConfig.Symbol.DOUBLE_QUOTE.toString())) {
            target = target.substring(1);
        }
        if (target.endsWith(SymbolConfig.Symbol.DOUBLE_QUOTE.toString())) {
            target = target.substring(0, target.length() - 1);
        }
        String slash = SymbolConfig.Symbol.SLASH.toString();
        char slashChar = SymbolConfig.Symbol.SLASH.toChar();
        if (Protocol.Type.HTTP.verify(target)) {
            return target;
        }
        if (target.startsWith(slash)) {
            String prefix = Protocol.Type.HTTP.prefix(source);
            int index = source.indexOf(slashChar, prefix.length());
            if (index > prefix.length()) {
                return source.substring(0, index) + target;
            }
            return source + target;
        }
        String prefix = Protocol.Type.HTTP.prefix(source);
        int index = source.lastIndexOf(slashChar);
        if (index > prefix.length()) {
            return source.substring(0, index) + slash + target;
        }
        return source + slash + target;
    }
}

