/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.autoconfigure;

import com.alibaba.boot.nacos.config.autoconfigure.NacosBootConfigException;
import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigApplicationInitializer;
import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.Function;
import com.alibaba.boot.nacos.config.util.NacosConfigLoader;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosConfigEnvironmentProcessor
implements EnvironmentPostProcessor,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigEnvironmentProcessor.class);
    private final CacheableEventPublishingNacosServiceFactory nacosServiceFactory = CacheableEventPublishingNacosServiceFactory.getSingleton();
    private final LinkedList<NacosConfigLoader.DeferNacosPropertySource> deferPropertySources = new LinkedList();
    private final Map<String, ConfigService> serviceCache = new HashMap<String, ConfigService>(8);
    private NacosConfigProperties nacosConfigProperties;
    private final Function<Properties, ConfigService> builder = new Function<Properties, ConfigService>(){

        @Override
        public ConfigService apply(Properties input) {
            try {
                String key = NacosUtils.identify((Map)input);
                ConfigService service = (ConfigService)NacosConfigEnvironmentProcessor.this.serviceCache.get(key);
                if (service != null) {
                    return (ConfigService)NacosConfigEnvironmentProcessor.this.serviceCache.get(key);
                }
                service = NacosFactory.createConfigService((Properties)input);
                NacosConfigEnvironmentProcessor.this.serviceCache.put(key, service);
                return (ConfigService)NacosConfigEnvironmentProcessor.this.nacosServiceFactory.deferCreateService((Object)service, input);
            }
            catch (NacosException e) {
                throw new NacosBootConfigException("ConfigService can't be created with properties : " + input, e);
            }
        }
    };

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        application.addInitializers(new ApplicationContextInitializer[]{new NacosConfigApplicationInitializer(this)});
        this.nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(environment);
        if (this.enable()) {
            System.out.println("[Nacos Config Boot] : The preload log configuration is enabled");
            this.loadConfig(environment);
        }
    }

    private void loadConfig(ConfigurableEnvironment environment) {
        NacosConfigLoader configLoader = new NacosConfigLoader(this.nacosConfigProperties, environment, this.builder);
        configLoader.loadConfig();
        this.deferPropertySources.addAll(configLoader.getNacosPropertySources());
    }

    boolean enable() {
        return this.nacosConfigProperties != null && this.nacosConfigProperties.getBootstrap().isLogEnable();
    }

    LinkedList<NacosConfigLoader.DeferNacosPropertySource> getDeferPropertySources() {
        return this.deferPropertySources;
    }

    void publishDeferService(ApplicationContext context) {
        try {
            this.nacosServiceFactory.publishDeferService(context);
            this.serviceCache.clear();
        }
        catch (Exception e) {
            this.logger.error("publish defer ConfigService has some error : {}", (Throwable)e);
        }
    }

    public int getOrder() {
        return 0x7FFFFFFA;
    }
}

