/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.autoconfigure;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.boot.nacos.config.util.NacosPropertiesBuilder;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.core.env.NacosPropertySourcePostProcessor;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.nacos.spring.util.config.NacosConfigLoader;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class NacosConfigApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigApplicationContextInitializer.class);
    private ConfigurableEnvironment environment;
    private NacosConfigProperties nacosConfigProperties;
    private NacosConfigLoader nacosConfigLoader;

    public void initialize(ConfigurableApplicationContext context) {
        CacheableEventPublishingNacosServiceFactory singleton = CacheableEventPublishingNacosServiceFactory.getSingleton();
        singleton.setApplicationContext((ApplicationContext)context);
        this.environment = context.getEnvironment();
        this.nacosConfigLoader = new NacosConfigLoader(this.environment);
        this.nacosConfigLoader.setNacosServiceFactory((NacosServiceFactory)singleton);
        if (!this.isEnable()) {
            this.logger.info("[Nacos Config Boot] : The preload configuration is not enabled");
        } else {
            this.nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(this.environment);
            Properties globalProperties = this.buildGlobalNacosProperties();
            MutablePropertySources mutablePropertySources = this.environment.getPropertySources();
            mutablePropertySources.addLast((PropertySource)this.reqGlobalNacosConfig(globalProperties, this.nacosConfigProperties.getType()));
            for (NacosConfigProperties.Config config : this.nacosConfigProperties.getExtConfig()) {
                mutablePropertySources.addLast((PropertySource)this.reqSubNacosConfig(config, globalProperties, config.getType()));
            }
        }
    }

    private boolean isEnable() {
        return Boolean.valueOf(this.environment.getProperty("nacos.config.bootstrap.enable", "false"));
    }

    private Properties buildGlobalNacosProperties() {
        return NacosPropertiesBuilder.buildNacosProperties(this.nacosConfigProperties.getServerAddr(), this.nacosConfigProperties.getNamespace(), this.nacosConfigProperties.getEndpoint(), this.nacosConfigProperties.getSecretKey(), this.nacosConfigProperties.getAccessKey(), this.nacosConfigProperties.getConfigLongPollTimeout(), this.nacosConfigProperties.getConfigRetryTime(), this.nacosConfigProperties.getMaxRetry(), this.nacosConfigProperties.isEnableRemoteSyncConfig());
    }

    private Properties buildSubNacosProperties(Properties globalProperties, NacosConfigProperties.Config config) {
        if (StringUtils.isEmpty((Object)config.getServerAddr())) {
            return globalProperties;
        }
        Properties sub = NacosPropertiesBuilder.buildNacosProperties(config.getServerAddr(), config.getNamespace(), config.getEndpoint(), config.getSecretKey(), config.getAccessKey(), config.getConfigLongPollTimeout(), config.getConfigRetryTime(), config.getMaxRetry(), config.isEnableRemoteSyncConfig());
        NacosPropertiesBuilder.merge(sub, globalProperties);
        return sub;
    }

    private NacosPropertySource reqGlobalNacosConfig(Properties globalProperties, ConfigType type) {
        NacosPropertySource propertySource = this.reqNacosConfig(globalProperties, this.nacosConfigProperties.getDataId(), this.nacosConfigProperties.getGroup(), type);
        propertySource.setAutoRefreshed(this.nacosConfigProperties.isAutoRefresh());
        NacosPropertySourcePostProcessor.addListenerIfAutoRefreshed((NacosPropertySource)propertySource, (Properties)globalProperties, (ConfigurableEnvironment)this.environment);
        return propertySource;
    }

    private NacosPropertySource reqSubNacosConfig(NacosConfigProperties.Config config, Properties globalProperties, ConfigType type) {
        Properties subConfigProperties = this.buildSubNacosProperties(globalProperties, config);
        NacosPropertySource nacosPropertySource = this.reqNacosConfig(subConfigProperties, config.getDataId(), config.getGroup(), type);
        nacosPropertySource.setAutoRefreshed(config.isAutoRefresh());
        NacosPropertySourcePostProcessor.addListenerIfAutoRefreshed((NacosPropertySource)nacosPropertySource, (Properties)subConfigProperties, (ConfigurableEnvironment)this.environment);
        return nacosPropertySource;
    }

    private NacosPropertySource reqNacosConfig(Properties configProperties, String dataId, String groupId, ConfigType type) {
        String config = this.nacosConfigLoader.load(dataId, groupId, configProperties);
        NacosPropertySource nacosPropertySource = new NacosPropertySource(dataId, groupId, NacosUtils.buildDefaultPropertySourceName((String)dataId, (String)groupId, (Map)configProperties), config, type.getType());
        nacosPropertySource.setDataId(dataId);
        nacosPropertySource.setType(type.getType());
        nacosPropertySource.setGroupId(groupId);
        return nacosPropertySource;
    }
}

