/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.editor.NacosCharSequenceEditor;
import com.alibaba.boot.nacos.config.util.editor.NacosCustomBooleanEditor;
import com.alibaba.boot.nacos.config.util.editor.NacosEnumEditor;
import com.alibaba.nacos.api.config.ConfigType;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class NacosConfigPropertiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(NacosConfigPropertiesUtils.class);

    public static NacosConfigProperties buildNacosConfigProperties(ConfigurableEnvironment environment) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)new NacosConfigProperties());
        wrapper.setAutoGrowNestedPaths(true);
        wrapper.setExtractOldValueForEditor(true);
        wrapper.registerCustomEditor(String.class, (PropertyEditor)new NacosCharSequenceEditor());
        wrapper.registerCustomEditor(Boolean.TYPE, (PropertyEditor)new NacosCustomBooleanEditor(true));
        wrapper.registerCustomEditor(ConfigType.class, (PropertyEditor)new NacosEnumEditor(ConfigType.class));
        wrapper.registerCustomEditor(Collection.class, (PropertyEditor)new CustomCollectionEditor(ArrayList.class));
        PropertySource<Map<String, String>> target = NacosConfigPropertiesUtils.findApplicationConfig(environment);
        wrapper.setPropertyValues(NacosConfigPropertiesUtils.dataSource((Map)target.getSource()));
        NacosConfigProperties nacosConfigProperties = (NacosConfigProperties)wrapper.getWrappedInstance();
        logger.debug("nacosConfigProperties : {}", (Object)nacosConfigProperties);
        return nacosConfigProperties;
    }

    private static PropertySource<Map<String, String>> findApplicationConfig(ConfigurableEnvironment environment) {
        PropertySource target = null;
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        for (PropertySource tmp : mutablePropertySources) {
            if (!(tmp instanceof OriginTrackedMapPropertySource)) continue;
            target = tmp;
        }
        return target;
    }

    private static Map<String, String> dataSource(Map<String, String> source) {
        source.remove("nacos.config.bootstrap.enable");
        String prefix = "nacos.config.";
        HashMap<String, String> targetConfigInfo = new HashMap<String, String>(source.size());
        for (Map.Entry<String, String> entry : source.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            String key = entry.getKey().replace(prefix, "");
            if (key.contains("-")) {
                String[] subs = key.split("-");
                key = NacosConfigPropertiesUtils.buildJavaField(subs);
            }
            targetConfigInfo.put(key, entry.getValue());
        }
        return targetConfigInfo;
    }

    private static String buildJavaField(String[] subs) {
        StringBuilder sb = new StringBuilder();
        sb.append(subs[0]);
        for (int i = 1; i < subs.length; ++i) {
            char[] chars = subs[i].toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            sb.append(chars);
        }
        return sb.toString();
    }
}

