/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util.editor;

import com.alibaba.nacos.api.config.ConfigType;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;

public class NacosEnumEditor
implements PropertyEditor {
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private final Class type;
    private final String[] tags;
    private Object value;

    public NacosEnumEditor(Class var1) {
        T[] var2 = var1.getEnumConstants();
        if (var2 == null) {
            throw new IllegalArgumentException("Unsupported " + var1);
        }
        this.type = var1;
        this.tags = new String[var2.length];
        for (int var3 = 0; var3 < var2.length; ++var3) {
            this.tags[var3] = ((Enum)var2[var3]).name();
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object var1) {
        if (var1 instanceof CharSequence) {
            PropertyChangeListener[] var3;
            Object var2;
            ConfigType bean = ConfigType.valueOf((String)String.valueOf(var1).toUpperCase());
            List<PropertyChangeListener> list = this.listeners;
            synchronized (list) {
                var2 = this.value;
                this.value = bean;
                if (!(bean == null ? var2 != null : !bean.equals(var2))) {
                    return;
                }
                int var5 = this.listeners.size();
                if (var5 == 0) {
                    return;
                }
                var3 = this.listeners.toArray(new PropertyChangeListener[var5]);
            }
            PropertyChangeEvent var4 = new PropertyChangeEvent(this, null, var2, bean);
            PropertyChangeListener[] var10 = var3;
            int var6 = var3.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                PropertyChangeListener var8 = var10[var7];
                var8.propertyChange(var4);
            }
        }
    }

    @Override
    public String getAsText() {
        return this.value != null ? ((Enum)this.value).name() : null;
    }

    @Override
    public void setAsText(String var1) {
        this.setValue(var1 != null ? Enum.valueOf(this.type, var1) : null);
    }

    @Override
    public String[] getTags() {
        return (String[])this.tags.clone();
    }

    @Override
    public String getJavaInitializationString() {
        String var1 = this.getAsText();
        return var1 != null ? this.type.getName() + '.' + var1 : "null";
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics var1, Rectangle var2) {
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener var1) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(var1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener var1) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(var1);
        }
    }
}

