/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.endpoint;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.StringUtils;

public class NacosConfigHealthIndicator
extends AbstractHealthIndicator {
    private final NacosConfigProperties nacosConfigProperties;
    private final List<String> dataIds;
    private final ConfigService configService;

    public NacosConfigHealthIndicator(NacosConfigProperties nacosConfigProperties, ConfigService configService) {
        this.nacosConfigProperties = nacosConfigProperties;
        this.configService = configService;
        this.dataIds = new ArrayList<String>();
        for (NacosPropertySource nacosPropertySource : NacosPropertySourceRepository.getAll()) {
            this.dataIds.add(nacosPropertySource.getDataId());
        }
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        for (String dataId : this.dataIds) {
            try {
                String config = this.configService.getConfig(dataId, this.nacosConfigProperties.getGroup(), (long)this.nacosConfigProperties.getTimeout());
                if (!StringUtils.isEmpty((Object)config)) continue;
                builder.down().withDetail(String.format("dataId: '%s', group: '%s'", dataId, this.nacosConfigProperties.getGroup()), (Object)"config is empty");
            }
            catch (Exception e) {
                builder.down().withDetail(String.format("dataId: '%s', group: '%s'", dataId, this.nacosConfigProperties.getGroup()), (Object)e.getMessage());
            }
        }
        builder.up().withDetail("dataIds", this.dataIds);
    }
}

