/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.AbstractNacosDataParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NacosDataPropertiesParser
extends AbstractNacosDataParser {
    private static final Logger log = LoggerFactory.getLogger(NacosDataPropertiesParser.class);

    public NacosDataPropertiesParser() {
        super("properties");
    }

    @Override
    protected Map<String, Object> doParse(String data) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try (BufferedReader reader = new BufferedReader(new StringReader(data));){
            String line = reader.readLine();
            while (line != null) {
                String dataLine = line.trim();
                if (!StringUtils.isEmpty((Object)dataLine) && !dataLine.startsWith("#")) {
                    int index = dataLine.indexOf("=");
                    if (index == -1) {
                        log.warn("the config data is invalid {}", (Object)dataLine);
                    } else {
                        result.put(dataLine.substring(0, index), dataLine.substring(index + 1));
                    }
                }
                line = reader.readLine();
            }
        }
        return result;
    }
}

