/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class NacosWatch
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(NacosWatch.class);
    private final NacosDiscoveryProperties properties;
    private final TaskScheduler taskScheduler;
    private final AtomicLong nacosWatchIndex = new AtomicLong(0L);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> watchFuture;

    public NacosWatch(NacosDiscoveryProperties properties) {
        this(properties, (TaskScheduler)NacosWatch.getTaskScheduler());
    }

    public NacosWatch(NacosDiscoveryProperties properties, TaskScheduler taskScheduler) {
        this.properties = properties;
        this.taskScheduler = taskScheduler;
    }

    public NacosWatch(NacosDiscoveryProperties properties, ObjectProvider<TaskScheduler> taskScheduler) {
        this(properties, (TaskScheduler)taskScheduler.getIfAvailable(NacosWatch::getTaskScheduler));
    }

    private static ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setBeanName("Nacso-Watch-Task-Scheduler");
        taskScheduler.initialize();
        return taskScheduler;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(this::nacosServicesWatch, this.properties.getWatchDelay());
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            ((ThreadPoolTaskScheduler)this.taskScheduler).shutdown();
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public void nacosServicesWatch() {
        this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.nacosWatchIndex.getAndIncrement()));
    }
}

