/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.catchlog;

import com.alibaba.cola.catchlog.ResponseHandlerI;
import com.alibaba.cola.dto.Response;
import com.alibaba.cola.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseHandler
implements ResponseHandlerI {
    private static final Logger log = LoggerFactory.getLogger(DefaultResponseHandler.class);

    @Override
    public Object handle(Class returnType, String errCode, String errMsg) {
        if (DefaultResponseHandler.isColaResponse(returnType)) {
            return DefaultResponseHandler.handleColaResponse(returnType, errCode, errMsg);
        }
        return null;
    }

    public Object handle(Class returnType, BaseException e) {
        return this.handle(returnType, e.getErrCode(), e.getMessage());
    }

    private static Object handleColaResponse(Class returnType, String errCode, String errMsg) {
        try {
            Response response = (Response)returnType.newInstance();
            response.setSuccess(false);
            response.setErrCode(errCode);
            response.setErrMessage(errMsg);
            return response;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static boolean isColaResponse(Class returnType) {
        return returnType == Response.class || returnType.getGenericSuperclass() == Response.class;
    }
}

