/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec;

import com.alibaba.csp.sentinel.cluster.codec.EntityWriter;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityWriter;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.Response;
import com.alibaba.csp.sentinel.cluster.server.codec.registry.ResponseDataWriterRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.buffer.ByteBuf;

public class DefaultResponseEntityWriter
implements ResponseEntityWriter<ClusterResponse, ByteBuf> {
    public void writeTo(ClusterResponse response, ByteBuf out) {
        int type = response.getType();
        EntityWriter<Object, ByteBuf> responseDataWriter = ResponseDataWriterRegistry.getWriter(type);
        if (responseDataWriter == null) {
            this.writeHead((Response)response.setStatus(-1), out);
            RecordLog.warn((String)"[NettyResponseEncoder] Cannot find matching writer for type <{0}>", (Object[])new Object[]{response.getType()});
            return;
        }
        this.writeHead((Response)response, out);
        responseDataWriter.writeTo(response.getData(), (Object)out);
    }

    private void writeHead(Response response, ByteBuf out) {
        out.writeInt(response.getId());
        out.writeByte(response.getType());
        out.writeByte(response.getStatus());
    }
}

