/*
 * Copyright 1999-2019 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.csp.sentinel.cluster.server.quota;

/**
 * @author Eric Zhao
 * @since 1.7.0
 */
public enum QuotaStatus {

    /**
     * Success.
     */
    OK(0),
    /**
     * Connection count exceeded.
     */
    CONN_COUNT_EXCEEDED(1);

    private int code;

    QuotaStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }
}
