/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.controller;

import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slots.block.flow.controller.WarmUpController;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.concurrent.atomic.AtomicLong;

public class WarmUpRateLimiterController
extends WarmUpController {
    private final int timeoutInMs;
    private final AtomicLong latestPassedTime = new AtomicLong(-1L);

    public WarmUpRateLimiterController(double count, int warmUpPeriodSec, int timeOutMs, int coldFactor) {
        super(count, warmUpPeriodSec, coldFactor);
        this.timeoutInMs = timeOutMs;
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        return this.canPass(node, acquireCount, false);
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        long previousQps = (long)node.previousPassQps();
        this.syncToken(previousQps);
        long currentTime = TimeUtil.currentTimeMillis();
        long restToken = this.storedTokens.get();
        long costTime = 0L;
        long expectedTime = 0L;
        if (restToken >= (long)this.warningToken) {
            long aboveToken = restToken - (long)this.warningToken;
            double warmingQps = Math.nextUp(1.0 / ((double)aboveToken * this.slope + 1.0 / this.count));
            costTime = Math.round(1.0 * (double)acquireCount / warmingQps * 1000.0);
        } else {
            costTime = Math.round(1.0 * (double)acquireCount / this.count * 1000.0);
        }
        expectedTime = costTime + this.latestPassedTime.get();
        if (expectedTime <= currentTime) {
            this.latestPassedTime.set(currentTime);
            return true;
        }
        long waitTime = costTime + this.latestPassedTime.get() - currentTime;
        if (waitTime > (long)this.timeoutInMs) {
            return false;
        }
        long oldTime = this.latestPassedTime.addAndGet(costTime);
        try {
            waitTime = oldTime - TimeUtil.currentTimeMillis();
            if (waitTime > (long)this.timeoutInMs) {
                this.latestPassedTime.addAndGet(-costTime);
                return false;
            }
            if (waitTime > 0L) {
                Thread.sleep(waitTime);
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

