/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.view;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.taobao.csp.sentinel.dashboard.datasource.entity.DegradeRuleEntity;
import com.taobao.csp.sentinel.dashboard.datasource.entity.RuleEntity;
import com.taobao.csp.sentinel.dashboard.discovery.MachineInfo;
import com.taobao.csp.sentinel.dashboard.inmem.HttpHelper;
import com.taobao.csp.sentinel.dashboard.inmem.InMemDegradeRuleStore;
import com.taobao.csp.sentinel.dashboard.view.Result;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/degrade"}, produces={"application/json"})
public class DegradeController {
    private static Logger logger = LoggerFactory.getLogger(DegradeController.class);
    @Autowired
    InMemDegradeRuleStore repository;
    @Autowired
    private HttpHelper httpHelper;

    @ResponseBody
    @RequestMapping(value={"/rules.json"})
    Result<List<DegradeRuleEntity>> queryMachineRules(String app, String ip, Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        try {
            List rules = this.httpHelper.fetchDegradeRuleOfMachine(app, ip, port.intValue());
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess((Object)rules);
        }
        catch (Throwable throwable) {
            logger.error("queryApps error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/new.json"})
    Result<?> add(String app, String ip, Integer port, String limitApp, String resource, Double count, Integer timeWindow, Integer grade) {
        if (StringUtil.isBlank((String)app)) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isBlank((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        if (StringUtil.isBlank((String)limitApp)) {
            return Result.ofFail((int)-1, (String)"limitApp can't be null or empty");
        }
        if (StringUtil.isBlank((String)resource)) {
            return Result.ofFail((int)-1, (String)"resource can't be null or empty");
        }
        if (count == null) {
            return Result.ofFail((int)-1, (String)"count can't be null");
        }
        if (timeWindow == null) {
            return Result.ofFail((int)-1, (String)"timeWindow can't be null");
        }
        if (grade == null) {
            return Result.ofFail((int)-1, (String)"grade can't be null");
        }
        if (grade != 0 && grade != 1) {
            return Result.ofFail((int)-1, (String)("grade must be 0 or 1, but " + grade + " got"));
        }
        DegradeRuleEntity entity = new DegradeRuleEntity();
        entity.setApp(app.trim());
        entity.setIp(ip.trim());
        entity.setPort(port);
        entity.setLimitApp(limitApp.trim());
        entity.setResource(resource.trim());
        entity.setCount(count);
        entity.setTimeWindow(timeWindow);
        entity.setGrade(grade);
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (DegradeRuleEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            logger.error("add error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(app, ip, port)) {
            logger.info("publish degrade rules fail after rule add");
        }
        return Result.ofSuccess((Object)entity);
    }

    @ResponseBody
    @RequestMapping(value={"/save.json"})
    Result<?> updateIfNotNull(Long id, String app, String limitApp, String resource, Double count, Integer timeWindow, Integer grade) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        if (grade != null && grade != 0 && grade != 1) {
            return Result.ofFail((int)-1, (String)("grade must be 0 or 1, but " + grade + " got"));
        }
        DegradeRuleEntity entity = (DegradeRuleEntity)this.repository.findById(id);
        if (entity == null) {
            return Result.ofFail((int)-1, (String)("id " + id + " dose not exist"));
        }
        if (StringUtil.isNotBlank((String)app)) {
            entity.setApp(app.trim());
        }
        if (StringUtil.isNotBlank((String)limitApp)) {
            entity.setLimitApp(limitApp.trim());
        }
        if (StringUtil.isNotBlank((String)resource)) {
            entity.setResource(resource.trim());
        }
        if (count != null) {
            entity.setCount(count);
        }
        if (timeWindow != null) {
            entity.setTimeWindow(timeWindow);
        }
        if (grade != null) {
            entity.setGrade(grade);
        }
        Date date = new Date();
        entity.setGmtModified(date);
        try {
            entity = (DegradeRuleEntity)this.repository.save((RuleEntity)entity);
        }
        catch (Throwable throwable) {
            logger.error("save error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            logger.info("publish degrade rules fail after rule update");
        }
        return Result.ofSuccess((Object)entity);
    }

    @ResponseBody
    @RequestMapping(value={"/delete.json"})
    Result<?> delete(Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id can't be null");
        }
        DegradeRuleEntity oldEntity = (DegradeRuleEntity)this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete(id);
        }
        catch (Throwable throwable) {
            logger.error("delete error:", throwable);
            return Result.ofThrowable((int)-1, (Throwable)throwable);
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            logger.info("publish degrade rules fail after rule delete");
        }
        return Result.ofSuccess((Object)id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.httpHelper.setDegradeRuleOfMachine(app, ip, port.intValue(), rules);
    }
}

