/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.view;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.taobao.csp.sentinel.dashboard.domain.ResourceTreeNode;
import com.taobao.csp.sentinel.dashboard.inmem.HttpHelper;
import com.taobao.csp.sentinel.dashboard.view.Result;
import com.taobao.csp.sentinel.dashboard.view.vo.ResourceVo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/resource"}, produces={"application/json"})
public class ResourceController {
    private static Logger logger = LoggerFactory.getLogger(ResourceController.class);
    @Autowired
    HttpHelper httpFetcher;

    @ResponseBody
    @RequestMapping(value={"/machineResource.json"})
    Result<?> fetchIdentityOfMachine(String ip, Integer port, String type, String searchKey) {
        if (StringUtil.isEmpty((String)ip) || port == null) {
            return Result.ofFail((int)-1, (String)"invalid param, give ip, port");
        }
        String ROOT = "root";
        String DEFAULT = "default";
        if (StringUtil.isEmpty((String)type)) {
            type = "root";
        }
        if ("root".equalsIgnoreCase(type) || "default".equalsIgnoreCase(type)) {
            List nodeVos = this.httpFetcher.fetchResourceOfMachine(ip, port.intValue(), type);
            if (nodeVos == null) {
                return Result.ofSuccess(null);
            }
            ResourceTreeNode treeNode = ResourceTreeNode.fromNodeVoList((List)nodeVos);
            treeNode.searchIgnoreCase(searchKey);
            return Result.ofSuccess((Object)ResourceVo.fromResourceTreeNode((ResourceTreeNode)treeNode));
        }
        List nodeVos = this.httpFetcher.fetchClusterNodeOfMachine(ip, port.intValue(), true);
        if (nodeVos == null) {
            return Result.ofSuccess(null);
        }
        if (StringUtil.isNotEmpty((String)searchKey)) {
            nodeVos = nodeVos.stream().filter(node -> node.getResource().toLowerCase().contains(searchKey.toLowerCase())).collect(Collectors.toList());
        }
        return Result.ofSuccess((Object)ResourceVo.fromNodeVoList((List)nodeVos));
    }
}

