/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.nacos;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NacosDataSource<T>
extends AbstractDataSource<String, T> {
    private static final int DEFAULT_TIMEOUT = 3000;
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("sentinel-nacos-ds-update", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final Listener configListener;
    private final String groupId;
    private final String dataId;
    private final Properties properties;
    private ConfigService configService = null;

    public NacosDataSource(String serverAddr, String groupId, String dataId, Converter<String, T> parser) {
        this(NacosDataSource.buildProperties(serverAddr), groupId, dataId, parser);
    }

    public NacosDataSource(final Properties properties, final String groupId, final String dataId, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: groupId=[%s], dataId=[%s]", groupId, dataId));
        }
        AssertUtil.notNull((Object)properties, (String)"Nacos properties must not be null, you could put some keys from PropertyKeyConst");
        this.groupId = groupId;
        this.dataId = dataId;
        this.properties = properties;
        this.configListener = new Listener(){

            public Executor getExecutor() {
                return NacosDataSource.this.pool;
            }

            public void receiveConfigInfo(String configInfo) {
                RecordLog.info((String)"[NacosDataSource] New property value received for (properties: {}) (dataId: {}, groupId: {}): {}", (Object[])new Object[]{properties, dataId, groupId, configInfo});
                Object newValue = NacosDataSource.this.parser.convert((Object)configInfo);
                NacosDataSource.this.getProperty().updateValue(newValue);
            }
        };
        this.initNacosListener();
        this.loadInitialConfig();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[NacosDataSource] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[NacosDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    private void initNacosListener() {
        try {
            this.configService = NacosFactory.createConfigService((Properties)this.properties);
            this.configService.addListener(this.dataId, this.groupId, this.configListener);
        }
        catch (Exception e) {
            RecordLog.warn((String)"[NacosDataSource] Error occurred when initializing Nacos data source", (Throwable)e);
            e.printStackTrace();
        }
    }

    public String readSource() throws Exception {
        if (this.configService == null) {
            throw new IllegalStateException("Nacos config service has not been initialized or error occurred");
        }
        return this.configService.getConfig(this.dataId, this.groupId, 3000L);
    }

    public void close() {
        if (this.configService != null) {
            this.configService.removeListener(this.dataId, this.groupId, this.configListener);
        }
        this.pool.shutdownNow();
    }

    private static Properties buildProperties(String serverAddr) {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", serverAddr);
        return properties;
    }
}

