/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.reactor;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class AsyncFunctional {
    public static <R> CompletableFuture<R> runAsyncWith(String resource, Supplier<R> f, ExecutorService pool) {
        try {
            AsyncEntry entry = SphU.asyncEntry((String)resource);
            return CompletableFuture.supplyAsync(f, pool).whenComplete((r, ex) -> {
                try {
                    if (ex != null) {
                        Tracer.traceContext((Throwable)ex, (int)1, (Context)entry.getAsyncContext());
                    }
                }
                finally {
                    if (entry != null) {
                        entry.exit();
                    }
                }
            });
        }
        catch (BlockException ex2) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(ex2);
            return future;
        }
    }
}

