/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.StatisticNode;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import java.util.Map;

@CommandMapping(name="origin")
public class FetchOriginCommandHandler
implements CommandHandler<String> {
    private static final String FORMAT = "%-4s%-80s%-10s%-10s%-11s%-9s%-6s%-10s%-11s%-9s";
    private static final int MAX_LEN = 79;

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        StringBuilder sb = new StringBuilder();
        String name = request.getParam("id");
        ClusterNode cNode = null;
        boolean exactly = false;
        for (Map.Entry e : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            if (!((ResourceWrapper)e.getKey()).getName().equals(name)) continue;
            cNode = (ClusterNode)e.getValue();
            sb.append("id: ").append(((ResourceWrapper)e.getKey()).getShowName()).append("\n");
            sb.append("\n");
            exactly = true;
            break;
        }
        if (!exactly) {
            for (Map.Entry e : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
                if (((ResourceWrapper)e.getKey()).getName().indexOf(name) <= 0) continue;
                cNode = (ClusterNode)e.getValue();
                sb.append("id: ").append(((ResourceWrapper)e.getKey()).getShowName()).append("\n");
                sb.append("\n");
                break;
            }
        }
        if (cNode == null) {
            return CommandResponse.ofSuccess("Not find cNode with id " + name);
        }
        int i = 0;
        int nameLength = 0;
        for (Map.Entry e : cNode.getOriginCountMap().entrySet()) {
            int l = ((String)e.getKey()).length();
            if (l > nameLength) {
                nameLength = l;
            }
            if (++i != 120) continue;
            break;
        }
        nameLength = nameLength > 79 ? 79 : nameLength;
        String format = FORMAT.replaceAll("80", String.valueOf(nameLength + 1));
        i = 0;
        sb.append(String.format(format, "idx", "origin", "threadNum", "passedQps", "blockedQps", "totalQps", "aRt", "1m-passed", "1m-blocked", "1m-total")).append("\n");
        for (Map.Entry e : cNode.getOriginCountMap().entrySet()) {
            StatisticNode node = (StatisticNode)e.getValue();
            String id = (String)e.getKey();
            int lenNum = (int)Math.ceil((double)id.length() / (double)nameLength) - 1;
            sb.append(String.format(format, i + 1, lenNum == 0 ? id : id.substring(0, nameLength), node.curThreadNum(), node.passQps(), node.blockedQps(), node.totalQps(), node.avgRt(), node.totalRequest() - node.blockedRequest(), node.blockedRequest(), node.totalRequest())).append("\n");
            for (int j = 1; j <= lenNum; ++j) {
                int start = nameLength * j;
                int end = j == lenNum ? id.length() : nameLength * (j + 1);
                sb.append(String.format(format, "", id.substring(start, end), "", "", "", "", "", "", "", "", "", "", "", "")).append("\n");
            }
            if (++i != 30) continue;
            break;
        }
        return CommandResponse.ofSuccess(sb.toString());
    }
}

