/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.datasource.DataSource;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import java.net.URLDecoder;
import java.util.List;

@CommandMapping(name="setRules")
public class ModifyRulesCommandHandler
implements CommandHandler<String> {
    static DataSource<?, List<FlowRule>> flowDataSource = null;
    static DataSource<?, List<AuthorityRule>> authorityDataSource = null;
    static DataSource<?, List<DegradeRule>> degradeDataSource = null;
    static DataSource<?, List<SystemRule>> systemSource = null;

    public static synchronized void registerFlowDataSource(DataSource<?, List<FlowRule>> datasource) {
        flowDataSource = datasource;
    }

    public static synchronized void registerAuthorityDataSource(DataSource<?, List<AuthorityRule>> dataSource) {
        authorityDataSource = dataSource;
    }

    public static synchronized void registerDegradeDataSource(DataSource<?, List<DegradeRule>> dataSource) {
        degradeDataSource = dataSource;
    }

    public static synchronized void registerSystemDataSource(DataSource<?, List<SystemRule>> dataSource) {
        systemSource = dataSource;
    }

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String type = request.getParam("type");
        String data = request.getParam("data");
        if (StringUtil.isNotEmpty((String)data)) {
            try {
                data = URLDecoder.decode(data, "utf-8");
            }
            catch (Exception e) {
                RecordLog.info((String)"decode rule data error", (Throwable)e);
                return CommandResponse.ofFailure(e, "decode rule data error");
            }
        }
        RecordLog.info((String)("receive rule change:" + type));
        RecordLog.info((String)data);
        String result = "success";
        if ("flow".equalsIgnoreCase(type)) {
            List flowRules = JSONArray.parseArray((String)data, FlowRule.class);
            FlowRuleManager.loadRules((List)flowRules);
            if (flowDataSource != null) {
                try {
                    flowDataSource.writeDataSource((Object)flowRules);
                }
                catch (Exception e) {
                    result = "partial success";
                    RecordLog.info((String)e.getMessage(), (Throwable)e);
                }
            }
            return CommandResponse.ofSuccess(result);
        }
        if ("authority".equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, AuthorityRule.class);
            AuthorityRuleManager.loadRules((List)rules);
            if (authorityDataSource != null) {
                try {
                    authorityDataSource.writeDataSource((Object)rules);
                }
                catch (Exception e) {
                    result = "partial success";
                    RecordLog.info((String)e.getMessage(), (Throwable)e);
                }
            }
            return CommandResponse.ofSuccess(result);
        }
        if ("degrade".equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, DegradeRule.class);
            DegradeRuleManager.loadRules((List)rules);
            if (degradeDataSource != null) {
                try {
                    degradeDataSource.writeDataSource((Object)rules);
                }
                catch (Exception e) {
                    result = "partial success";
                    RecordLog.info((String)e.getMessage(), (Throwable)e);
                }
            }
            return CommandResponse.ofSuccess(result);
        }
        if ("system".equalsIgnoreCase(type)) {
            List rules = JSONArray.parseArray((String)data, SystemRule.class);
            SystemRuleManager.loadRules((List)rules);
            if (systemSource != null) {
                try {
                    systemSource.writeDataSource((Object)rules);
                }
                catch (Exception e) {
                    result = "partial success";
                    RecordLog.info((String)e.getMessage(), (Throwable)e);
                }
            }
            return CommandResponse.ofSuccess(result);
        }
        return CommandResponse.ofFailure(new IllegalArgumentException("invalid type"));
    }
}

