/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command.http;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.CommandCenterLog;
import com.alibaba.csp.sentinel.transport.command.SimpleHttpCommandCenter;
import com.alibaba.csp.sentinel.transport.util.HttpCommandUtils;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class HttpEventTask
implements Runnable {
    private final Socket socket;
    private boolean writtenHead = false;
    private static final String SERVER_ERROR_MESSAGE = "Command server error";

    public HttpEventTask(Socket socket) {
        this.socket = socket;
    }

    public void close() throws Exception {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String commandName;
        CommandRequest request;
        String line;
        OutputStream outputStream;
        long start;
        PrintWriter printWriter;
        BufferedReader in;
        block13: {
            if (this.socket == null) {
                return;
            }
            in = null;
            printWriter = null;
            start = System.currentTimeMillis();
            in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), SentinelConfig.charset()));
            outputStream = this.socket.getOutputStream();
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, Charset.forName(SentinelConfig.charset())));
            line = in.readLine();
            CommandCenterLog.info((String)("[CommandCenter] socket income:" + line + "," + this.socket.getInetAddress()));
            request = this.parseRequest(line);
            commandName = HttpCommandUtils.getTarget((CommandRequest)request);
            if (!StringUtil.isBlank((String)commandName)) break block13;
            this.badRequest(printWriter, "Invalid command");
            this.closeResource(in);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
            return;
        }
        try {
            CommandHandler commandHandler = SimpleHttpCommandCenter.getHandler(commandName);
            if (commandHandler != null) {
                CommandResponse response = commandHandler.handle(request);
                this.handleResponse(response, printWriter, outputStream);
            } else {
                this.badRequest(printWriter, "Unknown command `" + commandName + '`');
            }
            printWriter.flush();
            long cost = System.currentTimeMillis() - start;
            CommandCenterLog.info((String)("[CommandCenter] deal a socket task:" + line + "," + this.socket.getInetAddress() + ", time cost=" + cost + " ms"));
            this.closeResource(in);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
        }
        catch (Throwable e) {
            try {
                CommandCenterLog.info((String)"CommandCenter error", (Throwable)e);
                try {
                    if (printWriter != null) {
                        String errorMessage = SERVER_ERROR_MESSAGE;
                        if (!this.writtenHead) {
                            this.internalError(printWriter, errorMessage);
                        } else {
                            printWriter.println(errorMessage);
                        }
                        printWriter.flush();
                    }
                }
                catch (Exception e1) {
                    CommandCenterLog.info((String)"CommandCenter close serverSocket failed", (Throwable)e);
                }
                this.closeResource(in);
                this.closeResource(printWriter);
                this.closeResource(this.socket);
            }
            catch (Throwable throwable) {
                this.closeResource(in);
                this.closeResource(printWriter);
                this.closeResource(this.socket);
                throw throwable;
            }
        }
    }

    private void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                CommandCenterLog.info((String)"CommandCenter close resource failed", (Throwable)e);
            }
        }
    }

    private void handleResponse(CommandResponse response, PrintWriter printWriter, OutputStream rawOutputStream) throws Exception {
        if (response.isSuccess()) {
            if (response.getResult() == null) {
                this.writeOkStatusLine(printWriter);
                return;
            }
            this.writeOkStatusLine(printWriter);
            byte[] buffer = response.getResult().toString().getBytes(SentinelConfig.charset());
            rawOutputStream.write(buffer);
            rawOutputStream.flush();
        } else {
            String msg = SERVER_ERROR_MESSAGE;
            if (response.getException() != null) {
                msg = response.getException().getMessage();
            }
            this.badRequest(printWriter, msg);
        }
    }

    private void badRequest(PrintWriter out, String message) {
        out.print("HTTP/1.1 400 Bad Request\r\nConnection: close\r\n\r\n");
        out.print(message);
        out.flush();
        this.writtenHead = true;
    }

    private void internalError(PrintWriter out, String message) {
        out.print("HTTP/1.1 500 Internal Server Error\r\nConnection: close\r\n\r\n");
        out.print(message);
        out.flush();
        this.writtenHead = true;
    }

    private void writeOkStatusLine(PrintWriter out) {
        out.print("HTTP/1.1 200 OK\r\nConnection: close\r\n\r\n");
        out.flush();
        this.writtenHead = true;
    }

    private CommandRequest parseRequest(String line) {
        CommandRequest request = new CommandRequest();
        if (StringUtil.isBlank((String)line)) {
            return request;
        }
        int start = line.indexOf(47);
        int ask = line.indexOf(63) == -1 ? line.lastIndexOf(32) : line.indexOf(63);
        int space = line.lastIndexOf(32);
        String target = line.substring(start != -1 ? start + 1 : 0, ask != -1 ? ask : line.length());
        request.addMetadata("command-target", target);
        if (ask == -1 || ask == space) {
            return request;
        }
        String parameterStr = line.substring(ask != -1 ? ask + 1 : 0, space != -1 ? space : line.length());
        for (String parameter : parameterStr.split("&")) {
            String[] keyValue;
            if (StringUtil.isBlank((String)parameter) || (keyValue = parameter.split("=")).length != 2) continue;
            String value = StringUtil.trim((String)keyValue[1]);
            try {
                value = URLDecoder.decode(value, SentinelConfig.charset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            request.addParam(StringUtil.trim((String)keyValue[0]), value);
        }
        return request;
    }
}

