/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.transport.heartbeat.HeartbeatMessage;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpClient;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpRequest;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class SimpleHttpHeartbeatSender
implements HeartbeatSender {
    private static final String HEARTBEAT_PATH = "/registry/machine";
    private static final int OK_STATUS = 200;
    private static final long DEFAULT_INTERVAL = 10000L;
    private final HeartbeatMessage heartBeat = new HeartbeatMessage();
    private final SimpleHttpClient httpClient = new SimpleHttpClient();
    private final List<InetSocketAddress> addressList;
    private int currentAddressIdx = 0;

    public SimpleHttpHeartbeatSender() {
        List<InetSocketAddress> newAddrs = this.getDefaultConsoleIps();
        RecordLog.info((String)("[SimpleHttpHeartbeatSender] Default console address list retrieved: " + newAddrs));
        this.addressList = newAddrs;
        String interval = System.getProperty("csp.sentinel.heartbeat.interval.ms", String.valueOf(10000L));
        SentinelConfig.setConfig((String)"csp.sentinel.heartbeat.interval.ms", (String)interval);
    }

    public boolean sendHeartbeat() throws Exception {
        if (TransportConfig.getRuntimePort() <= 0) {
            RecordLog.info((String)"[SimpleHttpHeartbeatSender] Runtime port not initialized, won't send heartbeat");
            return false;
        }
        InetSocketAddress addr = this.getAvailableAddress();
        if (addr == null) {
            return false;
        }
        SimpleHttpRequest request = new SimpleHttpRequest(addr, HEARTBEAT_PATH);
        request.setParams(this.heartBeat.generateCurrentMessage());
        try {
            SimpleHttpResponse response = this.httpClient.post(request);
            if (response.getStatusCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            RecordLog.info((String)("Failed to send heart beat to " + addr + " : "), (Throwable)e);
        }
        return false;
    }

    public long intervalMs() {
        return 10000L;
    }

    private InetSocketAddress getAvailableAddress() {
        if (this.addressList == null || this.addressList.isEmpty()) {
            return null;
        }
        if (this.currentAddressIdx < 0) {
            this.currentAddressIdx = 0;
        }
        int index = this.currentAddressIdx % this.addressList.size();
        return this.addressList.get(index);
    }

    private List<InetSocketAddress> getDefaultConsoleIps() {
        ArrayList<InetSocketAddress> newAddrs = new ArrayList<InetSocketAddress>();
        try {
            String ipsStr = TransportConfig.getConsoleServer();
            if (StringUtil.isEmpty((String)ipsStr)) {
                return newAddrs;
            }
            for (String ipPortStr : ipsStr.split(",")) {
                if (ipPortStr.trim().length() == 0) continue;
                if (ipPortStr.startsWith("http://")) {
                    ipPortStr = ipPortStr.trim().substring(7);
                }
                String[] ipPort = ipPortStr.trim().split(":");
                int port = 80;
                if (ipPort.length > 1) {
                    port = Integer.parseInt(ipPort[1].trim());
                }
                newAddrs.add(new InetSocketAddress(ipPort[0].trim(), port));
            }
        }
        catch (Exception ex) {
            RecordLog.info((String)("[SimpleHeartbeatSender] Parse console list failed, current address list: " + newAddrs), (Throwable)ex);
            ex.printStackTrace();
        }
        return newAddrs;
    }
}

