/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.context;

import com.alibaba.excel.context.GenerateContext;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.CellRange;
import com.alibaba.excel.metadata.ExcelHeadProperty;
import com.alibaba.excel.metadata.Table;
import com.alibaba.excel.metadata.TableStyle;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GenerateContextImpl
implements GenerateContext {
    private Sheet currentSheet;
    private String currentSheetName;
    private ExcelTypeEnum excelType;
    private Workbook workbook;
    private OutputStream outputStream;
    private Map<Integer, Sheet> sheetMap = new ConcurrentHashMap<Integer, Sheet>();
    private Map<Integer, Table> tableMap = new ConcurrentHashMap<Integer, Table>();
    private CellStyle defaultCellStyle;
    private CellStyle currentHeadCellStyle;
    private CellStyle currentContentCellStyle;
    private ExcelHeadProperty excelHeadProperty;
    private boolean needHead = true;

    public GenerateContextImpl(InputStream templateInputStream, OutputStream out, ExcelTypeEnum excelType, boolean needHead) throws IOException {
        this.workbook = ExcelTypeEnum.XLS.equals((Object)excelType) ? (templateInputStream == null ? new HSSFWorkbook() : new HSSFWorkbook(new POIFSFileSystem(templateInputStream))) : (templateInputStream == null ? new SXSSFWorkbook(500) : new SXSSFWorkbook(new XSSFWorkbook(templateInputStream)));
        this.outputStream = out;
        this.defaultCellStyle = this.buildDefaultCellStyle();
        this.needHead = needHead;
    }

    private CellStyle buildDefaultCellStyle() {
        CellStyle newCellStyle = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)14);
        font.setBold(true);
        newCellStyle.setFont(font);
        newCellStyle.setWrapText(true);
        newCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        newCellStyle.setAlignment(HorizontalAlignment.CENTER);
        newCellStyle.setLocked(true);
        newCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        newCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        newCellStyle.setBorderBottom(BorderStyle.THIN);
        newCellStyle.setBorderLeft(BorderStyle.THIN);
        return newCellStyle;
    }

    @Override
    public void buildCurrentSheet(com.alibaba.excel.metadata.Sheet sheet) {
        if (this.sheetMap.containsKey(sheet.getSheetNo())) {
            this.currentSheet = this.sheetMap.get(sheet.getSheetNo());
        } else {
            Sheet sheet1 = null;
            try {
                sheet1 = this.workbook.getSheetAt(sheet.getSheetNo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sheet1 == null) {
                this.currentSheet = this.workbook.createSheet(sheet.getSheetName() != null ? sheet.getSheetName() : sheet.getSheetNo() + "");
                this.currentSheet.setDefaultColumnWidth(20);
                for (Map.Entry<Integer, Integer> entry : sheet.getColumnWidthMap().entrySet()) {
                    this.currentSheet.setColumnWidth(entry.getKey().intValue(), entry.getValue().intValue());
                }
            } else {
                this.currentSheet = sheet1;
            }
            this.sheetMap.put(sheet.getSheetNo(), this.currentSheet);
            this.buildHead(sheet.getHead(), sheet.getClazz());
            this.buildTableStyle(sheet.getTableStyle());
            if (this.needHead && this.excelHeadProperty != null) {
                this.appendHeadToExcel();
            }
        }
    }

    private void buildHead(List<List<String>> head, Class<? extends BaseRowModel> clazz) {
        if (head != null || clazz != null) {
            this.excelHeadProperty = new ExcelHeadProperty(clazz, head);
        }
    }

    public void appendHeadToExcel() {
        if (this.excelHeadProperty.getHead() != null && this.excelHeadProperty.getHead().size() > 0) {
            List<CellRange> list = this.excelHeadProperty.getCellRangeModels();
            int n = this.currentSheet.getLastRowNum();
            if (n > 0) {
                n += 4;
            }
            for (CellRange cellRangeModel : list) {
                CellRangeAddress cra = new CellRangeAddress(cellRangeModel.getFirstRow() + n, cellRangeModel.getLastRow() + n, cellRangeModel.getFirstCol(), cellRangeModel.getLastCol());
                this.currentSheet.addMergedRegion(cra);
            }
            for (int i = n; i < this.excelHeadProperty.getRowNum() + n; ++i) {
                Row row = this.currentSheet.createRow(i);
                this.addOneRowOfHeadDataToExcel(row, this.excelHeadProperty.getHeadByRowNum(i - n));
            }
        }
    }

    private void addOneRowOfHeadDataToExcel(Row row, List<String> headByRowNum) {
        if (headByRowNum != null && headByRowNum.size() > 0) {
            for (int i = 0; i < headByRowNum.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(this.getCurrentHeadCellStyle());
                cell.setCellValue(headByRowNum.get(i));
            }
        }
    }

    private void buildTableStyle(TableStyle tableStyle) {
        if (tableStyle != null) {
            CellStyle headStyle = this.buildDefaultCellStyle();
            if (tableStyle.getTableHeadFont() != null) {
                Font font = this.workbook.createFont();
                font.setFontName(tableStyle.getTableHeadFont().getFontName());
                font.setFontHeightInPoints(tableStyle.getTableHeadFont().getFontHeightInPoints());
                font.setBold(tableStyle.getTableHeadFont().isBold());
                headStyle.setFont(font);
            }
            if (tableStyle.getTableHeadBackGroundColor() != null) {
                headStyle.setFillForegroundColor(tableStyle.getTableHeadBackGroundColor().getIndex());
            }
            this.currentHeadCellStyle = headStyle;
            CellStyle contentStyle = this.buildDefaultCellStyle();
            if (tableStyle.getTableContentFont() != null) {
                Font font = this.workbook.createFont();
                font.setFontName(tableStyle.getTableContentFont().getFontName());
                font.setFontHeightInPoints(tableStyle.getTableContentFont().getFontHeightInPoints());
                font.setBold(tableStyle.getTableContentFont().isBold());
                contentStyle.setFont(font);
            }
            if (tableStyle.getTableContentBackGroundColor() != null) {
                contentStyle.setFillForegroundColor(tableStyle.getTableContentBackGroundColor().getIndex());
            }
            this.currentContentCellStyle = contentStyle;
        }
    }

    @Override
    public void buildTable(Table table) {
        if (!this.tableMap.containsKey(table.getTableNo())) {
            this.buildHead(table.getHead(), table.getClazz());
            this.tableMap.put(table.getTableNo(), table);
            this.buildTableStyle(table.getTableStyle());
            if (this.needHead && this.excelHeadProperty != null) {
                this.appendHeadToExcel();
            }
        }
    }

    @Override
    public ExcelHeadProperty getExcelHeadProperty() {
        return this.excelHeadProperty;
    }

    @Override
    public boolean needHead() {
        return this.needHead;
    }

    @Override
    public Sheet getCurrentSheet() {
        return this.currentSheet;
    }

    public void setCurrentSheet(Sheet currentSheet) {
        this.currentSheet = currentSheet;
    }

    public String getCurrentSheetName() {
        return this.currentSheetName;
    }

    public void setCurrentSheetName(String currentSheetName) {
        this.currentSheetName = currentSheetName;
    }

    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public CellStyle getCurrentHeadCellStyle() {
        return this.currentHeadCellStyle == null ? this.defaultCellStyle : this.currentHeadCellStyle;
    }

    @Override
    public CellStyle getCurrentContentStyle() {
        return this.currentContentCellStyle;
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }
}

