/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class TypeUtil {
    private static List<SimpleDateFormat> DATE_FORMAT_LIST = new ArrayList<SimpleDateFormat>(4);
    public static final Pattern pattern;

    private static int getCountOfChar(String value, char c) {
        char[] chars;
        int n = 0;
        if (value == null) {
            return 0;
        }
        for (char cc : chars = value.toCharArray()) {
            if (cc != c) continue;
            ++n;
        }
        return n;
    }

    public static Object convert(String value, Field field, String format, boolean us) {
        if (TypeUtil.isNotEmpty(value).booleanValue()) {
            if (String.class.equals(field.getType())) {
                return TypeUtil.formatFloat(value);
            }
            if (Integer.class.equals(field.getType()) || Integer.TYPE.equals(field.getType())) {
                return Integer.parseInt(value);
            }
            if (Double.class.equals(field.getType()) || Double.TYPE.equals(field.getType())) {
                if (null != format && !"".equals(format)) {
                    int n = TypeUtil.getCountOfChar(value, '0');
                    return Double.parseDouble(TypeUtil.formatFloat0(value, n));
                }
                return Double.parseDouble(TypeUtil.formatFloat(value));
            }
            if (Boolean.class.equals(field.getType()) || Boolean.TYPE.equals(field.getType())) {
                String valueLower = value.toLowerCase();
                if (valueLower.equals("true") || valueLower.equals("false")) {
                    return Boolean.parseBoolean(value.toLowerCase());
                }
                Integer integer = Integer.parseInt(value);
                if (integer == 0) {
                    return false;
                }
                return true;
            }
            if (Long.class.equals(field.getType()) || Long.TYPE.equals(field.getType())) {
                return Long.parseLong(value);
            }
            if (Date.class.equals(field.getType())) {
                if (value.contains("-") || value.contains("/") || value.contains(":")) {
                    return TypeUtil.getSimpleDateFormatDate(value, format);
                }
                Double d = Double.parseDouble(value);
                return HSSFDateUtil.getJavaDate((double)d, (boolean)us);
            }
            if (BigDecimal.class.equals(field.getType())) {
                return new BigDecimal(value);
            }
        }
        return null;
    }

    public static Boolean isNum(Field field) {
        if (field == null) {
            return false;
        }
        if (Integer.class.equals(field.getType()) || Integer.TYPE.equals(field.getType())) {
            return true;
        }
        if (Double.class.equals(field.getType()) || Double.TYPE.equals(field.getType())) {
            return true;
        }
        if (Long.class.equals(field.getType()) || Long.TYPE.equals(field.getType())) {
            return true;
        }
        if (BigDecimal.class.equals(field.getType())) {
            return true;
        }
        return false;
    }

    public static String getDefaultDateString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static Date getSimpleDateFormatDate(String value, String format) {
        if (TypeUtil.isNotEmpty(value).booleanValue()) {
            Date date = null;
            if (TypeUtil.isNotEmpty(format).booleanValue()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
                try {
                    date = simpleDateFormat.parse(value);
                    return date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            for (SimpleDateFormat dateFormat : DATE_FORMAT_LIST) {
                try {
                    date = dateFormat.parse(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (date == null) continue;
                break;
            }
            return date;
        }
        return null;
    }

    public static Boolean isNotEmpty(String value) {
        if (value == null) {
            return false;
        }
        if (value.trim().equals("")) {
            return false;
        }
        return true;
    }

    public static String formatFloat(String value) {
        if (null != value && value.contains(".") && TypeUtil.isNumeric(value)) {
            try {
                BigDecimal decimal = new BigDecimal(value);
                BigDecimal setScale = decimal.setScale(10, 5).stripTrailingZeros();
                return setScale.toPlainString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static String formatFloat0(String value, int n) {
        if (null != value && value.contains(".") && TypeUtil.isNumeric(value)) {
            try {
                BigDecimal decimal = new BigDecimal(value);
                BigDecimal setScale = decimal.setScale(n, 5);
                return setScale.toPlainString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private static boolean isNumeric(String str) {
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String formatDate(Date cellValue, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(cellValue);
    }

    public static void main(String[] args) {
        System.out.println(new Date().toString());
    }

    static {
        DATE_FORMAT_LIST.add(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"));
        DATE_FORMAT_LIST.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        pattern = Pattern.compile("[\\+\\-]?[\\d]+([\\.][\\d]*)?([Ee][+-]?[\\d]+)?$");
    }
}

