/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.spi.server;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthPluginManager.class);
    private static final AuthPluginManager INSTANCE = new AuthPluginManager();
    private final Map<String, AuthPluginService> authServiceMap = new HashMap<String, AuthPluginService>();

    public AuthPluginManager() {
        this.initAuthServices();
    }

    private void initAuthServices() {
        Collection authPluginServices = NacosServiceLoader.load(AuthPluginService.class);
        for (AuthPluginService each : authPluginServices) {
            if (StringUtils.isEmpty((String)each.getAuthServiceName())) {
                LOGGER.warn("[AuthPluginManager] Load AuthPluginService({}) AuthServiceName(null/empty) fail. Please Add AuthServiceName to resolve.", each.getClass());
                continue;
            }
            this.authServiceMap.put(each.getAuthServiceName(), each);
            LOGGER.info("[AuthPluginManager] Load AuthPluginService({}) AuthServiceName({}) successfully.", each.getClass(), (Object)each.getAuthServiceName());
        }
    }

    public static AuthPluginManager getInstance() {
        return INSTANCE;
    }

    public Optional<AuthPluginService> findAuthServiceSpiImpl(String authServiceName) {
        return Optional.ofNullable(this.authServiceMap.get(authServiceName));
    }
}

