/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.filter.impl.ConfigFilterChainManager;
import com.alibaba.nacos.client.config.filter.impl.ConfigResponse;
import com.alibaba.nacos.client.config.impl.LocalConfigInfoProcessor;
import com.alibaba.nacos.client.config.impl.ManagerListenerWrap;
import com.alibaba.nacos.client.config.utils.LogUtils;
import com.alibaba.nacos.client.config.utils.MD5;
import com.alibaba.nacos.client.config.utils.TenantUtil;
import com.alibaba.nacos.client.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CacheData {
    public static final Logger log = LogUtils.logger(CacheData.class);
    private final String name;
    private final ConfigFilterChainManager configFilterChainManager;
    public final String dataId;
    public final String group;
    public final String tenant;
    private final CopyOnWriteArrayList<ManagerListenerWrap> listeners;
    private volatile String md5;
    private volatile boolean isUseLocalConfig = false;
    private volatile long localConfigLastModified;
    private volatile String content;
    private int taskId;
    private volatile boolean isInitializing = true;

    public boolean isInitializing() {
        return this.isInitializing;
    }

    public void setInitializing(boolean isInitializing) {
        this.isInitializing = isInitializing;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String newContent) {
        this.content = newContent;
        this.md5 = CacheData.getMd5String(this.content);
    }

    public void addListener(Listener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        ManagerListenerWrap wrap = new ManagerListenerWrap(listener);
        if (this.listeners.addIfAbsent(wrap)) {
            log.info(this.name, "[add-listener] ok, tenant={}, dataId={}, group={}, cnt={}", this.tenant, this.dataId, this.group, this.listeners.size());
        }
    }

    public void removeListener(Listener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("listener is null");
        }
        ManagerListenerWrap wrap = new ManagerListenerWrap(listener);
        if (this.listeners.remove(wrap)) {
            log.info(this.name, "[remove-listener] ok, dataId={}, group={}, cnt={}", this.dataId, this.group, this.listeners.size());
        }
    }

    public List<Listener> getListeners() {
        ArrayList<Listener> result = new ArrayList<Listener>();
        for (ManagerListenerWrap wrap : this.listeners) {
            result.add(wrap.listener);
        }
        return result;
    }

    public long getLocalConfigInfoVersion() {
        return this.localConfigLastModified;
    }

    public void setLocalConfigInfoVersion(long localConfigLastModified) {
        this.localConfigLastModified = localConfigLastModified;
    }

    public boolean isUseLocalConfigInfo() {
        return this.isUseLocalConfig;
    }

    public void setUseLocalConfigInfo(boolean useLocalConfigInfo) {
        this.isUseLocalConfig = useLocalConfigInfo;
        if (!useLocalConfigInfo) {
            this.localConfigLastModified = -1L;
        }
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CacheData other = (CacheData)obj;
        return this.dataId.equals(other.dataId) && this.group.equals(other.group);
    }

    public String toString() {
        return "CacheData [" + this.dataId + ", " + this.group + "]";
    }

    void checkListenerMd5() {
        for (ManagerListenerWrap wrap : this.listeners) {
            if (this.md5.equals(wrap.lastCallMd5)) continue;
            this.safeNotifyListener(this.dataId, this.group, this.content, this.md5, wrap);
        }
    }

    private void safeNotifyListener(final String dataId, final String group, final String content, final String md5, final ManagerListenerWrap listenerWrap) {
        final Listener listener = listenerWrap.listener;
        Runnable job = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader myClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader appClassLoader = listener.getClass().getClassLoader();
                try {
                    if (listener instanceof AbstractSharedListener) {
                        AbstractSharedListener adapter = (AbstractSharedListener)listener;
                        adapter.fillContext(dataId, group);
                        log.info(CacheData.this.name, "[notify-context] dataId={}, group={}, md5={}", dataId, group, md5);
                    }
                    Thread.currentThread().setContextClassLoader(appClassLoader);
                    ConfigResponse cr = new ConfigResponse();
                    cr.setDataId(dataId);
                    cr.setGroup(group);
                    cr.setContent(content);
                    CacheData.this.configFilterChainManager.doFilter(null, cr);
                    String contentTmp = cr.getContent();
                    listener.receiveConfigInfo(contentTmp);
                    listenerWrap.lastCallMd5 = md5;
                    log.info(CacheData.this.name, "[notify-ok] dataId={}, group={}, md5={}, listener={} ", dataId, group, md5, listener);
                }
                catch (NacosException de) {
                    log.error(CacheData.this.name, "NACOS-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} errCode={} errMsg={}", dataId, group, md5, listener, de.getErrCode(), de.getErrMsg());
                }
                catch (Throwable t) {
                    log.error(CacheData.this.name, "NACOS-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} tx={}", dataId, group, md5, listener, t.getCause());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(myClassLoader);
                }
            }
        };
        long startNotify = System.currentTimeMillis();
        try {
            if (null != listener.getExecutor()) {
                listener.getExecutor().execute(job);
            } else {
                job.run();
            }
        }
        catch (Throwable t) {
            log.error(this.name, "NACOS-XXXX", "[notify-error] dataId={}, group={}, md5={}, listener={} throwable={}", dataId, group, md5, listener, t.getCause());
        }
        long finishNotify = System.currentTimeMillis();
        log.info(this.name, "[notify-listener] time cost={}ms in ClientWorker, dataId={}, group={}, md5={}, listener={} ", finishNotify - startNotify, dataId, group, md5, listener);
    }

    public static String getMd5String(String config) {
        return null == config ? "" : MD5.getInstance().getMD5String(config);
    }

    private String loadCacheContentFromDiskLocal(String name, String dataId, String group, String tenant) {
        String content = LocalConfigInfoProcessor.getFailover(name, dataId, group, tenant);
        content = null != content ? content : LocalConfigInfoProcessor.getSnapshot(name, dataId, group, tenant);
        return content;
    }

    public CacheData(ConfigFilterChainManager configFilterChainManager, String name, String dataId, String group) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException("dataId=" + dataId + ", group=" + group);
        }
        this.name = name;
        this.configFilterChainManager = configFilterChainManager;
        this.dataId = dataId;
        this.group = group;
        this.tenant = TenantUtil.getUserTenant();
        this.listeners = new CopyOnWriteArrayList();
        this.isInitializing = true;
        this.content = this.loadCacheContentFromDiskLocal(name, dataId, group, this.tenant);
        this.md5 = CacheData.getMd5String(this.content);
    }

    public CacheData(ConfigFilterChainManager configFilterChainManager, String name, String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException("dataId=" + dataId + ", group=" + group);
        }
        this.name = name;
        this.configFilterChainManager = configFilterChainManager;
        this.dataId = dataId;
        this.group = group;
        this.tenant = tenant;
        this.listeners = new CopyOnWriteArrayList();
        this.isInitializing = true;
        this.content = this.loadCacheContentFromDiskLocal(name, dataId, group, tenant);
        this.md5 = CacheData.getMd5String(this.content);
    }
}

