/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.utils;

import com.alibaba.nacos.api.utils.StringUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtils {
    private static String localIp;

    public static String localIP() {
        String ip;
        if (!StringUtils.isEmpty(localIp)) {
            return localIp;
        }
        localIp = ip = System.getProperty("com.alibaba.nacos.client.naming.local.ip", NetUtils.findFirstNonLoopbackAddress());
        return localIp;
    }

    private static String findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp() || ifc.getIndex() >= lowest && result != null) continue;
                lowest = ifc.getIndex();
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    boolean isLegalIpVersion = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses")) ? address instanceof Inet6Address : address instanceof Inet4Address;
                    if (!isLegalIpVersion || address.isLoopbackAddress()) continue;
                    result = address;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            return result.getHostAddress();
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "resolve_failed";
        }
    }
}

