/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.ConfigHttpClientManager;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.utils.ContextPathUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class ServerHttpAgent
implements HttpAgent {
    private static final Logger LOGGER = LogUtils.logger(ServerHttpAgent.class);
    private static final NacosRestTemplate NACOS_RESTTEMPLATE = ConfigHttpClientManager.getInstance().getNacosRestTemplate();
    private String encode;
    private int maxRetry = 3;
    final ServerListManager serverListMgr;

    @Override
    public HttpRestResult<String> httpGet(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        HttpClientConfig httpConfig = HttpClientConfig.builder().setReadTimeOutMillis(Long.valueOf(readTimeoutMs).intValue()).setConTimeOutMillis(ConfigHttpClientManager.getInstance().getConnectTimeoutOrDefault(100)).build();
        do {
            try {
                Header newHeaders = Header.newInstance();
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                Query query = Query.newInstance().initParams(paramValues);
                HttpRestResult<String> result = NACOS_RESTTEMPLATE.get(this.getUrl(currentServerAddr, path), httpConfig, newHeaders, query, (Type)((Object)String.class));
                if (!this.isFail(result)) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)result.getCode());
            }
            catch (ConnectException connectException) {
                LOGGER.error("[NACOS ConnectException httpGet] currentServerAddr:{}, err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)connectException.getMessage());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                LOGGER.error("[NACOS SocketTimeoutException httpGet] currentServerAddr:{}\uff0c err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)socketTimeoutException.getMessage());
            }
            catch (Exception ex) {
                LOGGER.error("[NACOS Exception httpGet] currentServerAddr: " + this.serverListMgr.getCurrentServerAddr(), (Throwable)ex);
                throw ex;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-GET] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server");
        throw new ConnectException("no available server");
    }

    @Override
    public HttpRestResult<String> httpPost(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        HttpClientConfig httpConfig = HttpClientConfig.builder().setReadTimeOutMillis(Long.valueOf(readTimeoutMs).intValue()).setConTimeOutMillis(ConfigHttpClientManager.getInstance().getConnectTimeoutOrDefault(3000)).build();
        do {
            try {
                HttpRestResult<String> result;
                Header newHeaders = Header.newInstance();
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                if (!this.isFail(result = NACOS_RESTTEMPLATE.postForm(this.getUrl(currentServerAddr, path), httpConfig, newHeaders, paramValues, (Type)((Object)String.class)))) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)currentServerAddr, (Object)result.getCode());
            }
            catch (ConnectException connectException) {
                LOGGER.error("[NACOS ConnectException httpPost] currentServerAddr: {}, err : {}", (Object)currentServerAddr, (Object)connectException.getMessage());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                LOGGER.error("[NACOS SocketTimeoutException httpPost] currentServerAddr: {}\uff0c err : {}", (Object)currentServerAddr, (Object)socketTimeoutException.getMessage());
            }
            catch (Exception ex) {
                LOGGER.error("[NACOS Exception httpPost] currentServerAddr: " + currentServerAddr, (Throwable)ex);
                throw ex;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-POST] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server, currentServerAddr : {}", (Object)currentServerAddr);
        throw new ConnectException("no available server, currentServerAddr : " + currentServerAddr);
    }

    @Override
    public HttpRestResult<String> httpDelete(String path, Map<String, String> headers, Map<String, String> paramValues, String encode, long readTimeoutMs) throws Exception {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        HttpClientConfig httpConfig = HttpClientConfig.builder().setReadTimeOutMillis(Long.valueOf(readTimeoutMs).intValue()).setConTimeOutMillis(ConfigHttpClientManager.getInstance().getConnectTimeoutOrDefault(100)).build();
        do {
            try {
                Header newHeaders = Header.newInstance();
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                Query query = Query.newInstance().initParams(paramValues);
                HttpRestResult<String> result = NACOS_RESTTEMPLATE.delete(this.getUrl(currentServerAddr, path), httpConfig, newHeaders, query, (Type)((Object)String.class));
                if (!this.isFail(result)) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)result.getCode());
            }
            catch (ConnectException connectException) {
                LOGGER.error("[NACOS ConnectException httpDelete] currentServerAddr:{}, err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)ExceptionUtil.getStackTrace(connectException));
            }
            catch (SocketTimeoutException stoe) {
                LOGGER.error("[NACOS SocketTimeoutException httpDelete] currentServerAddr:{}\uff0c err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)ExceptionUtil.getStackTrace(stoe));
            }
            catch (Exception ex) {
                LOGGER.error("[NACOS Exception httpDelete] currentServerAddr: " + this.serverListMgr.getCurrentServerAddr(), (Throwable)ex);
                throw ex;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-DELETE] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server");
        throw new ConnectException("no available server");
    }

    private String getUrl(String serverAddr, String relativePath) {
        return serverAddr + ContextPathUtil.normalizeContextPath(this.serverListMgr.getContentPath()) + relativePath;
    }

    private boolean isFail(HttpRestResult<String> result) {
        return result.getCode() == 500 || result.getCode() == 502 || result.getCode() == 503 || result.getCode() == 404;
    }

    public static String getAppname() {
        return ParamUtil.getAppName();
    }

    public ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public ServerHttpAgent(ServerListManager mgr, Properties properties) {
        this.serverListMgr = mgr;
    }

    public ServerHttpAgent(Properties properties) throws NacosException {
        this.serverListMgr = new ServerListManager(properties);
    }

    @Override
    public void start() throws NacosException {
        this.serverListMgr.start();
    }

    @Override
    public String getName() {
        return this.serverListMgr.getName();
    }

    @Override
    public String getNamespace() {
        return this.serverListMgr.getNamespace();
    }

    @Override
    public String getTenant() {
        return this.serverListMgr.getTenant();
    }

    @Override
    public String getEncode() {
        return this.encode;
    }

    @Override
    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        ConfigHttpClientManager.getInstance().shutdown();
        this.serverListMgr.shutdown();
        LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

