/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.selector.NamingSelector;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.core.Balancer;
import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.client.naming.event.InstancesChangeNotifier;
import com.alibaba.nacos.client.naming.event.InstancesDiff;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.remote.NamingClientProxyDelegate;
import com.alibaba.nacos.client.naming.selector.NamingSelectorFactory;
import com.alibaba.nacos.client.naming.selector.NamingSelectorWrapper;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.InitUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.PreInitUtils;
import com.alibaba.nacos.client.utils.ValidatorUtils;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class NacosNamingService
implements NamingService {
    private static final String DEFAULT_NAMING_LOG_FILE_PATH = "naming.log";
    private static final String UP = "UP";
    private static final String DOWN = "DOWN";
    private String namespace;
    @Deprecated
    private String logName;
    private ServiceInfoHolder serviceInfoHolder;
    private InstancesChangeNotifier changeNotifier;
    private NamingClientProxy clientProxy;
    private String notifierEventScope;

    public NacosNamingService(String serverList) throws NacosException {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", serverList);
        this.init(properties);
    }

    public NacosNamingService(Properties properties) throws NacosException {
        this.init(properties);
    }

    private void init(Properties properties) throws NacosException {
        PreInitUtils.asyncPreLoadCostComponent();
        NacosClientProperties nacosClientProperties = NacosClientProperties.PROTOTYPE.derive(properties);
        LogUtils.NAMING_LOGGER.info(ParamUtil.getInputParameters(nacosClientProperties.asProperties()));
        ValidatorUtils.checkInitParam(nacosClientProperties);
        this.namespace = InitUtils.initNamespaceForNaming(nacosClientProperties);
        InitUtils.initSerialization();
        InitUtils.initWebRootContext(nacosClientProperties);
        this.initLogName(nacosClientProperties);
        this.notifierEventScope = UUID.randomUUID().toString();
        this.changeNotifier = new InstancesChangeNotifier(this.notifierEventScope);
        NotifyCenter.registerToPublisher(InstancesChangeEvent.class, 16384);
        NotifyCenter.registerSubscriber(this.changeNotifier);
        this.serviceInfoHolder = new ServiceInfoHolder(this.namespace, this.notifierEventScope, nacosClientProperties);
        this.clientProxy = new NamingClientProxyDelegate(this.namespace, this.serviceInfoHolder, nacosClientProperties, this.changeNotifier);
    }

    @Deprecated
    private void initLogName(NacosClientProperties properties) {
        this.logName = properties.getProperty("com.alibaba.nacos.naming.log.filename", DEFAULT_NAMING_LOG_FILE_PATH);
    }

    @Override
    public void registerInstance(String serviceName, String ip, int port) throws NacosException {
        this.registerInstance(serviceName, ip, port, "DEFAULT");
    }

    @Override
    public void registerInstance(String serviceName, String groupName, String ip, int port) throws NacosException {
        this.registerInstance(serviceName, groupName, ip, port, "DEFAULT");
    }

    @Override
    public void registerInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        this.registerInstance(serviceName, "DEFAULT_GROUP", ip, port, clusterName);
    }

    @Override
    public void registerInstance(String serviceName, String groupName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setWeight(1.0);
        instance.setClusterName(clusterName);
        this.registerInstance(serviceName, groupName, instance);
    }

    @Override
    public void registerInstance(String serviceName, Instance instance) throws NacosException {
        this.registerInstance(serviceName, "DEFAULT_GROUP", instance);
    }

    @Override
    public void registerInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        NamingUtils.checkInstanceIsLegal(instance);
        this.checkAndStripGroupNamePrefix(instance, groupName);
        this.clientProxy.registerService(serviceName, groupName, instance);
    }

    @Override
    public void batchRegisterInstance(String serviceName, String groupName, List<Instance> instances) throws NacosException {
        NamingUtils.batchCheckInstanceIsLegal(instances);
        this.batchCheckAndStripGroupNamePrefix(instances, groupName);
        this.clientProxy.batchRegisterService(serviceName, groupName, instances);
    }

    @Override
    public void batchDeregisterInstance(String serviceName, String groupName, List<Instance> instances) throws NacosException {
        NamingUtils.batchCheckInstanceIsLegal(instances);
        this.batchCheckAndStripGroupNamePrefix(instances, groupName);
        this.clientProxy.batchDeregisterService(serviceName, groupName, instances);
    }

    @Override
    public void deregisterInstance(String serviceName, String ip, int port) throws NacosException {
        this.deregisterInstance(serviceName, ip, port, "DEFAULT");
    }

    @Override
    public void deregisterInstance(String serviceName, String groupName, String ip, int port) throws NacosException {
        this.deregisterInstance(serviceName, groupName, ip, port, "DEFAULT");
    }

    @Override
    public void deregisterInstance(String serviceName, String ip, int port, String clusterName) throws NacosException {
        this.deregisterInstance(serviceName, "DEFAULT_GROUP", ip, port, clusterName);
    }

    @Override
    public void deregisterInstance(String serviceName, String groupName, String ip, int port, String clusterName) throws NacosException {
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setClusterName(clusterName);
        this.deregisterInstance(serviceName, groupName, instance);
    }

    @Override
    public void deregisterInstance(String serviceName, Instance instance) throws NacosException {
        this.deregisterInstance(serviceName, "DEFAULT_GROUP", instance);
    }

    @Override
    public void deregisterInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        NamingUtils.checkInstanceIsLegal(instance);
        this.checkAndStripGroupNamePrefix(instance, groupName);
        this.clientProxy.deregisterService(serviceName, groupName, instance);
    }

    @Override
    public List<Instance> getAllInstances(String serviceName) throws NacosException {
        return this.getAllInstances(serviceName, new ArrayList<String>());
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, String groupName) throws NacosException {
        return this.getAllInstances(serviceName, groupName, new ArrayList<String>());
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, boolean subscribe) throws NacosException {
        return this.getAllInstances(serviceName, new ArrayList<String>(), subscribe);
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, String groupName, boolean subscribe) throws NacosException {
        return this.getAllInstances(serviceName, groupName, new ArrayList<String>(), subscribe);
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, List<String> clusters) throws NacosException {
        return this.getAllInstances(serviceName, clusters, true);
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, String groupName, List<String> clusters) throws NacosException {
        return this.getAllInstances(serviceName, groupName, clusters, true);
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, List<String> clusters, boolean subscribe) throws NacosException {
        return this.getAllInstances(serviceName, "DEFAULT_GROUP", clusters, subscribe);
    }

    @Override
    public List<Instance> getAllInstances(String serviceName, String groupName, List<String> clusters, boolean subscribe) throws NacosException {
        List<Instance> list;
        ServiceInfo serviceInfo = this.getServiceInfo(serviceName, groupName, clusters, subscribe);
        if (serviceInfo == null || CollectionUtils.isEmpty(list = serviceInfo.getHosts())) {
            return new ArrayList<Instance>();
        }
        return list;
    }

    @Override
    public List<Instance> selectInstances(String serviceName, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, new ArrayList<String>(), healthy);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, String groupName, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, groupName, healthy, true);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, boolean healthy, boolean subscribe) throws NacosException {
        return this.selectInstances(serviceName, new ArrayList<String>(), healthy, subscribe);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, String groupName, boolean healthy, boolean subscribe) throws NacosException {
        return this.selectInstances(serviceName, groupName, new ArrayList<String>(), healthy, subscribe);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, List<String> clusters, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, clusters, healthy, true);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, String groupName, List<String> clusters, boolean healthy) throws NacosException {
        return this.selectInstances(serviceName, groupName, clusters, healthy, true);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, List<String> clusters, boolean healthy, boolean subscribe) throws NacosException {
        return this.selectInstances(serviceName, "DEFAULT_GROUP", clusters, healthy, subscribe);
    }

    @Override
    public List<Instance> selectInstances(String serviceName, String groupName, List<String> clusters, boolean healthy, boolean subscribe) throws NacosException {
        ServiceInfo serviceInfo = this.getServiceInfo(serviceName, groupName, clusters, subscribe);
        return this.selectInstances(serviceInfo, healthy);
    }

    private List<Instance> selectInstances(ServiceInfo serviceInfo, boolean healthy) {
        List<Instance> list;
        if (serviceInfo == null || CollectionUtils.isEmpty(list = serviceInfo.getHosts())) {
            return new ArrayList<Instance>();
        }
        Iterator<Instance> iterator = list.iterator();
        while (iterator.hasNext()) {
            Instance instance = iterator.next();
            if (healthy == instance.isHealthy() && instance.isEnabled() && !(instance.getWeight() <= 0.0)) continue;
            iterator.remove();
        }
        return list;
    }

    private ServiceInfo getServiceInfoByFailover(String serviceName, String groupName, String clusterString) {
        return this.serviceInfoHolder.getFailoverServiceInfo(serviceName, groupName, clusterString);
    }

    private ServiceInfo getServiceInfoBySubscribe(String serviceName, String groupName, String clusterString, boolean subscribe) throws NacosException {
        ServiceInfo serviceInfo;
        if (subscribe) {
            serviceInfo = this.serviceInfoHolder.getServiceInfo(serviceName, groupName, clusterString);
            if (null == serviceInfo || !this.clientProxy.isSubscribed(serviceName, groupName, clusterString)) {
                serviceInfo = this.clientProxy.subscribe(serviceName, groupName, clusterString);
            }
        } else {
            serviceInfo = this.clientProxy.queryInstancesOfService(serviceName, groupName, clusterString, false);
        }
        return serviceInfo;
    }

    private ServiceInfo getServiceInfo(String serviceName, String groupName, List<String> clusters, boolean subscribe) throws NacosException {
        ServiceInfo serviceInfo;
        String clusterString = StringUtils.join(clusters, ",");
        if (this.serviceInfoHolder.isFailoverSwitch() && (serviceInfo = this.getServiceInfoByFailover(serviceName, groupName, clusterString)) != null && serviceInfo.getHosts().size() > 0) {
            LogUtils.NAMING_LOGGER.debug("getServiceInfo from failover,serviceName: {}  data:{}", (Object)serviceName, (Object)JacksonUtils.toJson(serviceInfo.getHosts()));
            return serviceInfo;
        }
        serviceInfo = this.getServiceInfoBySubscribe(serviceName, groupName, clusterString, subscribe);
        return serviceInfo;
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, new ArrayList<String>());
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, String groupName) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, groupName, true);
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, boolean subscribe) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, new ArrayList<String>(), subscribe);
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, String groupName, boolean subscribe) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, groupName, new ArrayList<String>(), subscribe);
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, List<String> clusters) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, clusters, true);
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, String groupName, List<String> clusters) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, groupName, clusters, true);
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, List<String> clusters, boolean subscribe) throws NacosException {
        return this.selectOneHealthyInstance(serviceName, "DEFAULT_GROUP", clusters, subscribe);
    }

    @Override
    public Instance selectOneHealthyInstance(String serviceName, String groupName, List<String> clusters, boolean subscribe) throws NacosException {
        ServiceInfo serviceInfo = this.getServiceInfo(serviceName, groupName, clusters, subscribe);
        return Balancer.RandomByWeight.selectHost(serviceInfo);
    }

    @Override
    public void subscribe(String serviceName, EventListener listener) throws NacosException {
        this.subscribe(serviceName, new ArrayList<String>(), listener);
    }

    @Override
    public void subscribe(String serviceName, String groupName, EventListener listener) throws NacosException {
        this.subscribe(serviceName, groupName, new ArrayList<String>(), listener);
    }

    @Override
    public void subscribe(String serviceName, List<String> clusters, EventListener listener) throws NacosException {
        this.subscribe(serviceName, "DEFAULT_GROUP", clusters, listener);
    }

    @Override
    public void subscribe(String serviceName, String groupName, List<String> clusters, EventListener listener) throws NacosException {
        NamingSelector clusterSelector = NamingSelectorFactory.newClusterSelector(clusters);
        this.doSubscribe(serviceName, groupName, NamingSelectorFactory.getUniqueClusterString(clusters), clusterSelector, listener);
    }

    @Override
    public void subscribe(String serviceName, NamingSelector selector, EventListener listener) throws NacosException {
        this.subscribe(serviceName, "DEFAULT_GROUP", selector, listener);
    }

    @Override
    public void subscribe(String serviceName, String groupName, NamingSelector selector, EventListener listener) throws NacosException {
        this.doSubscribe(serviceName, groupName, "", selector, listener);
    }

    private void doSubscribe(String serviceName, String groupName, String clusters, NamingSelector selector, EventListener listener) throws NacosException {
        if (selector == null || listener == null) {
            return;
        }
        NamingSelectorWrapper wrapper = new NamingSelectorWrapper(serviceName, groupName, clusters, selector, listener);
        this.notifyIfSubscribed(serviceName, groupName, wrapper);
        this.changeNotifier.registerListener(groupName, serviceName, wrapper);
        this.clientProxy.subscribe(serviceName, groupName, "");
    }

    @Override
    public void unsubscribe(String serviceName, EventListener listener) throws NacosException {
        this.unsubscribe(serviceName, new ArrayList<String>(), listener);
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, EventListener listener) throws NacosException {
        this.unsubscribe(serviceName, groupName, new ArrayList<String>(), listener);
    }

    @Override
    public void unsubscribe(String serviceName, List<String> clusters, EventListener listener) throws NacosException {
        this.unsubscribe(serviceName, "DEFAULT_GROUP", clusters, listener);
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, List<String> clusters, EventListener listener) throws NacosException {
        NamingSelector clusterSelector = NamingSelectorFactory.newClusterSelector(clusters);
        this.unsubscribe(serviceName, groupName, clusterSelector, listener);
    }

    @Override
    public void unsubscribe(String serviceName, NamingSelector selector, EventListener listener) throws NacosException {
        this.unsubscribe(serviceName, "DEFAULT_GROUP", selector, listener);
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, NamingSelector selector, EventListener listener) throws NacosException {
        this.doUnsubscribe(serviceName, groupName, selector, listener);
    }

    private void doUnsubscribe(String serviceName, String groupName, NamingSelector selector, EventListener listener) throws NacosException {
        if (selector == null || listener == null) {
            return;
        }
        NamingSelectorWrapper wrapper = new NamingSelectorWrapper(selector, listener);
        this.changeNotifier.deregisterListener(groupName, serviceName, wrapper);
        if (!this.changeNotifier.isSubscribed(groupName, serviceName)) {
            this.clientProxy.unsubscribe(serviceName, groupName, "");
        }
    }

    @Override
    public ListView<String> getServicesOfServer(int pageNo, int pageSize) throws NacosException {
        return this.getServicesOfServer(pageNo, pageSize, "DEFAULT_GROUP");
    }

    @Override
    public ListView<String> getServicesOfServer(int pageNo, int pageSize, String groupName) throws NacosException {
        return this.getServicesOfServer(pageNo, pageSize, groupName, null);
    }

    @Override
    public ListView<String> getServicesOfServer(int pageNo, int pageSize, AbstractSelector selector) throws NacosException {
        return this.getServicesOfServer(pageNo, pageSize, "DEFAULT_GROUP", selector);
    }

    @Override
    public ListView<String> getServicesOfServer(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        return this.clientProxy.getServiceList(pageNo, pageSize, groupName, selector);
    }

    @Override
    public List<ServiceInfo> getSubscribeServices() {
        return this.changeNotifier.getSubscribeServices();
    }

    @Override
    public String getServerStatus() {
        return this.clientProxy.serverHealthy() ? UP : DOWN;
    }

    @Override
    public void shutDown() throws NacosException {
        this.serviceInfoHolder.shutdown();
        this.clientProxy.shutdown();
        NotifyCenter.deregisterSubscriber(this.changeNotifier);
    }

    private void batchCheckAndStripGroupNamePrefix(List<Instance> instances, String groupName) throws NacosException {
        for (Instance instance : instances) {
            this.checkAndStripGroupNamePrefix(instance, groupName);
        }
    }

    private void checkAndStripGroupNamePrefix(Instance instance, String groupName) throws NacosException {
        String serviceName = instance.getServiceName();
        if (NamingUtils.isServiceNameCompatibilityMode(serviceName)) {
            String groupNameOfInstance = NamingUtils.getGroupName(serviceName);
            if (!groupName.equals(groupNameOfInstance)) {
                throw new NacosException(-400, String.format("wrong group name prefix of instance service name! it should be: %s, Instance: %s", groupName, instance));
            }
            instance.setServiceName(NamingUtils.getServiceName(serviceName));
        }
    }

    private void notifyIfSubscribed(String serviceName, String groupName, NamingSelectorWrapper wrapper) {
        if (this.changeNotifier.isSubscribed(groupName, serviceName)) {
            LogUtils.NAMING_LOGGER.warn("Duplicate subscribe for groupName: {}, serviceName: {}; directly use current cached to notify.", (Object)groupName, (Object)serviceName);
            ServiceInfo serviceInfo = this.serviceInfoHolder.getServiceInfo(serviceName, groupName, "");
            InstancesChangeEvent event = this.transferToEvent(serviceInfo);
            wrapper.notifyListener(event);
        }
    }

    private InstancesChangeEvent transferToEvent(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return null;
        }
        InstancesDiff diff = new InstancesDiff();
        diff.setAddedInstances(serviceInfo.getHosts());
        return new InstancesChangeEvent(this.notifierEventScope, serviceInfo.getName(), serviceInfo.getGroupName(), serviceInfo.getClusters(), serviceInfo.getHosts(), diff);
    }
}

