/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.DefaultAsyncHttpClientRequest;
import com.alibaba.nacos.common.http.client.DefaultHttpClientRequest;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.nio.client.HttpAsyncClients;

public abstract class AbstractHttpClientFactory
implements HttpClientFactory {
    @Override
    public final NacosRestTemplate createNacosRestTemplate() {
        RequestConfig requestConfig = this.getRequestConfig();
        return new NacosRestTemplate(new DefaultHttpClientRequest(HttpClients.custom().setDefaultRequestConfig(requestConfig).build()));
    }

    @Override
    public final NacosAsyncRestTemplate createNacosAsyncRestTemplate() {
        RequestConfig requestConfig = this.getRequestConfig();
        return new NacosAsyncRestTemplate(new DefaultAsyncHttpClientRequest(HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).build()));
    }

    private RequestConfig getRequestConfig() {
        HttpClientConfig httpClientConfig = this.buildHttpClientConfig();
        return RequestConfig.custom().setConnectTimeout(httpClientConfig.getConTimeOutMillis()).setSocketTimeout(httpClientConfig.getReadTimeOutMillis()).setMaxRedirects(httpClientConfig.getMaxRedirects()).build();
    }

    protected abstract HttpClientConfig buildHttpClientConfig();
}

